<?php

/**
 *
 * @extension       Marlev - Template Manager
 * @author          Lev Milicenco<support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2017 marlev.it All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
defined('_JEXEC') or die;

function defined_layout() {
    $layout = new stdClass();

//Define sections
    $header = ['position-1', 'logo_menu', 'position-2', 'position-3'];
    $content = ['position-4', 'contentcontainer', 'position-5'];
    $footer = ['position-6', 'position-7', 'position-8', 'copyrightcontainer'];
    $layout->sections = ["header" => $header, "content" => $content, "footer" => $footer];



//DEFINIZIONI PARAMS PER MODIFICA SEZIONI
    $layout->positions['ml_body'] = array(
        "width" => "",
        "defpositions" => [""],
        "positions" => false,
        "innertop" => false,
        "innerbottom" => false,
        "params" => ["sections", "optionbody"]
    );

    foreach ($layout->sections as $key => $value) {
        //in key _section per fissare possibile assomiglianze con i moduli, 
        //questa assegnazione e' per le sezioni
        $layout->positions[$key . '_section'] = array(
            "width" => "",
            "defpositions" => [""],
            "positions" => false,
            "innertop" => false,
            "innerbottom" => false,
            "params" => ["sections", "container"]
        );
        //foreach per le sezioni delle posizioni
        foreach ($value as $vkey => $vvalue) {
            $layout->positions[$vvalue . '_subsection'] = array(
                "width" => "",
                "defpositions" => [""],
                "positions" => false,
                "innertop" => false,
                "innerbottom" => false,
                "params" => ["sections", "optionssection"]
            );
        }
    }
// Contunua con la variabile giu $incontent_sections
//DEFINIZIONI PARAMS PER POSIZIONI DEI MODUL
//START FOREACHS PER l'assegnazione dei parametri ai posizioni simili    
    $default_4_moduli_attivi = ['position-1', 'position-2', 'position-3', 'position-4', 'position-5', 'position-6', 'position-7', 'position-8'];
    $layout->load = ["0ce1bf5e8247390bb15f9cbdb7c310df", "aecbc9b643e0b86b0daa9f0cd5f2ed77"];
    foreach ($default_4_moduli_attivi as $key => $value) {
        $layout->positions[$value] = array(
            "width" => "container",
            "defpositions" => [$value . "-1", $value . "-2", $value . "-3", $value . "-4"],
            "positions" => false,
            "innertop" => false,
            "innerbottom" => false,
            "params" => ["standard4col", "optionsfull"]//, "moveall"
        );
    }

    $default_inners_similar = ['incontent', 'bottomcontent', 'topcontent'];
    foreach ($default_inners_similar as $key => $value) {
        $layout->positions[$value] = array(
            "width" => "row-fluid",
            "defpositions" => [$value . '-1', $value . '-2', $value . '-3', $value . '-4'],
            "positions" => false,
            "innertop" => false,
            "innerbottom" => false,
            "params" => ["standard4col", "optionsfull"]//, "moveall"
        );
    }
    $default_breadkrumbs = ['breadcrumbs', 'breadcrumbs-bottom'];
    foreach ($default_breadkrumbs as $key => $value) {
        $layout->positions[$value] = array(
            "width" => "row-fluid",
            "defpositions" => [$value],
            "positions" => false,
            "innertop" => false,
            "innerbottom" => false,
            "params" => ["menufull"]
        );
    }
    //Aggiunta DEFINIZIONI PARAMS PER MODIFICA SEZIONI
    $incontent_sections = array_merge($default_breadkrumbs, $default_inners_similar);
    foreach ($incontent_sections as $vkey => $vvalue) {
        $layout->positions[$vvalue . '_subsection'] = array(
            "width" => "",
            "defpositions" => [""],
            "positions" => false,
            "innertop" => false,
            "innerbottom" => false,
            "params" => ["sections", "optionssection"]
        );
    }
    $layout->positions['logo_menu_subsection'] = array(
        "width" => "",
        "defpositions" => [""],
        "positions" => false,
        "innertop" => false,
        "innerbottom" => false,
        "params" => ["logo_menu_sub", "sections"]
    );
    //FINE



    $default_left_right = ['left', 'right'];
    foreach ($default_left_right as $key => $value) {
        $layout->positions[$value] = array(
            "width" => "container",
            "defpositions" => [$value],
            "positions" => false,
            "innertop" => false,
            "innerbottom" => false,
            "params" => ["leftright"]//, "moveall"
        );
    }

    $layout->positions['logo_menu'] = array(
        "width" => "container-fluid",
        "defpositions" => ["logo", "menu"],
        "positions" => ["logo", "menu"],
        "innertop" => false,
        "innerbottom" => false,
        "params" => ["menufull"]
    );

    $layout->positions['contentcontainer'] = array(
        "width" => "container",
        "defpositions" => ["left", "content", "right"],
        "positions" => ["left", "content", "right"],
        "innertop" => false,
        "innerbottom" => false,
        "params" => ["menufull"]
    );
    $layout->positions['copyrightcontainer'] = array(
        "width" => "container-fluid",
        "defpositions" => ["copyright", "socialbtn"],
        "positions" => ["copyright", "socialbtn"],
        "innertop" => false,
        "innerbottom" => false,
        "params" => ["menufull"]
    );
    $layout->positions['copyright'] = array(
        "width" => "",
        "defpositions" => ["copyright"],
        "positions" => false,
        "innertop" => false,
        "innerbottom" => false,
        "params" => ["9"]
    );
    $layout->positions['socialbtn'] = array(
        "width" => "",
        "defpositions" => ["socialbtn"],
        "positions" => false,
        "innertop" => false,
        "innerbottom" => false,
        "params" => ["3"]
    );


    $layout->positions['logo'] = array(
        "width" => "",
        "defpositions" => ["logo"],
        "positions" => false,
        "innertop" => false,
        "innerbottom" => false,
        "params" => ["logo"]
    );
    $layout->positions['menu'] = array(
        "width" => "",
        "defpositions" => ["menu"],
        "positions" => false,
        "innertop" => false,
        "innerbottom" => false,
        "params" => ["menu"]
    );

    $layout->positions['content'] = array(
        "width" => "container",
        "defpositions" => ["content"],
        "positions" => false,
        "innertop" => ["breadcrumbs", "topcontent"],
        "innerbottom" => ["incontent", "breadcrumbs-bottom", "bottomcontent"],
        "params" => ["content", "optionsfull"]//, "moveall"
    );




    $layout->params['standard4col'] = array(
        "mobcollayout" => [12, 12, 12, 12],
        "tabcollayout" => [6, 6, 6, 6],
        "defcollayout" => [3, 3, 3, 3],
        "maxcols" => 120,
        "numeric_position" => true,
        "colchange" => true,
        "options" => true,
        "invisible" => true
    );
    $layout->params['3-9'] = array(
        "mobcollayout" => [12, 12],
        "tabcollayout" => [12, 12],
        "defcollayout" => [3, 9],
        "maxcols" => 2,
        "numeric_position" => false,
        "colchange" => true,
        "options" => true,
        "invisible" => false
    );
    $layout->params['9'] = array(
        "mobcollayout" => [12],
        "tabcollayout" => [12],
        "defcollayout" => [9],
        "maxcols" => 1,
        "numeric_position" => false,
        "colchange" => true,
        "options" => true,
        "invisible" => false,
        "stile" => true,
        "font" => true
    );

    $layout->params['3'] = array(
        "mobcollayout" => [12],
        "tabcollayout" => [12],
        "defcollayout" => [3],
        "maxcols" => 12,
        "numeric_position" => false,
        "colchange" => true,
        "options" => true,
        "invisible" => false,
        "stile" => true,
        "font" => true
    );
    $layout->params['menu'] = array(
        "mobcollayout" => [12],
        "tabcollayout" => [12],
        "defcollayout" => [9],
        "maxcols" => 1,
        "numeric_position" => false,
        "colchange" => true,
        "options" => true,
        "effect" => true,
        "invisible" => false,
    );

    $layout->params['logo'] = array(
        "mobcollayout" => [12],
        "tabcollayout" => [12],
        "defcollayout" => [3],
        "maxcols" => 12,
        "numeric_position" => false,
        "colchange" => true,
        "options" => true,
        "effect" => true,
        "invisible" => false
    );


    $layout->params['menufull'] = array(
        "mobcollayout" => [12],
        "tabcollayout" => [12],
        "defcollayout" => [12],
        "maxcols" => 12,
        "numeric_position" => false,
        "options" => false,
        "colchange" => false,
        "invisible" => false
    );
    $layout->params['leftright'] = array(
        "mobcollayout" => [12],
        "tabcollayout" => [12],
        "defcollayout" => [3],
        "maxcols" => 12,
        "numeric_position" => false,
        "options" => true,
        "colchange" => true,
        "invisible" => true,
        "stile" => true,
        "font" => true
    );
    $layout->params['content'] = array(
        "mobcollayout" => [12],
        "tabcollayout" => [12],
        "defcollayout" => [6],
        "maxcols" => 12,
        "numeric_position" => false,
        "options" => true,
        "colchange" => true,
        "invisible" => true
    );
    $layout->params['sections'] = array(
        "mobcollayout" => [12],
        "tabcollayout" => [12],
        "defcollayout" => [6],
        "maxcols" => 1,
        "numeric_position" => false,
        "options" => true,
        "colchange" => false,
        "invisible" => false
    );
    $layout->params['optionsfull'] = array(
        "effect" => true,
        "backgroundall" => true,
        "stile" => true,
        "shadow" => true,
        "font" => true
    );
    $layout->params['optionssection'] = array(
        "backgroundall" => true,
        "stile" => true,
        "shadow" => true,
        "font" => true
    );
    $layout->params['container'] = array(
        "backgroundall" => true,
        "stile" => true,
        "font" => true
    );
    $layout->params['logo_menu_sub'] = array(
        "backgroundall" => true,
        "stile" => true,
        "shadow" => true
    );
    $layout->params['optionbody'] = array(
        "backgroundall" => true
    );


    //Static

    $layout->static['devices'] = ['pc' => 'pc', 'tablet' => 'tablet', 'mobile' => 'mobile'];
    //nomi di params, da aggiungere dopo ogni aggiunta
    $layout->static["avaiableoptions"] = ['container', 'optionsfull', 'optionssection', 'optionbody', "menu", "logo", "logo_menu_sub"];
    $layout->static["truefalse"] = array(
        'numeric_position',
        'colchange',
        'invisible',
        'push',
        'pull',
        'offset'
    );
    //default positions utilizzato in template.php
    $layout->defaultpositions = ["logo", "content"];


//    $generate_forxml = array_merge($default_inners_similar,$default_4_moduli_attivi);
//    function generate_positions_xml($generate_forxml){
//        $write = '';
//        foreach($generate_forxml as $key=>$value){
//            for($i = 1; $i <=24; $i++){
//                $write .= '<position>'.$value.'-'.$i.'</position>'.PHP_EOL;
//            }
//        }
//        //file_put_contents("/var/www/html//positions.txt", $write);
//   }
//   generate_positions_xml($generate_forxml);
    return $layout;
}
