<?php
/**
 *
 * @extension       YRPrice Calculator
 * @author          Lev Milicenco<support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2022 marlev.it All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL

 */
//for_use


defined('_JEXEC') or die;

use Joomla\CMS\Extension\MVCComponent;
use Marlev\Component\Tmarlevv2\Administrator\Extension\Tmarlevv2Component;
use Joomla\CMS\Categories\CategoryFactoryInterface;
use Joomla\CMS\Component\Router\RouterFactoryInterface;
use Joomla\CMS\Dispatcher\ComponentDispatcherFactoryInterface;
use Joomla\CMS\Extension\ComponentInterface;
use Joomla\CMS\Extension\Service\Provider\CategoryFactory;
use Joomla\CMS\Extension\Service\Provider\ComponentDispatcherFactory;
use Joomla\CMS\Extension\Service\Provider\MVCFactory;
use Joomla\CMS\Extension\Service\Provider\RouterFactory;
use Joomla\Component\Content\Administrator\Helper\AssociationsHelper;
use Joomla\CMS\HTML\Registry;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

return new class implements ServiceProviderInterface
{

    public function register(Container $container)
    {
        $container->set(AssociationExtensionInterface::class, new AssociationsHelper());
        //$container->registerServiceProvider(new CategoryFactory('\\Marlev\\Component\\Tmarlevv2'));
        $container->registerServiceProvider(new MVCFactory('\\Marlev\\Component\\Tmarlevv2'));
        $container->registerServiceProvider(new ComponentDispatcherFactory('\\Marlev\\Component\\Tmarlevv2'));
        $container->registerServiceProvider(new RouterFactory('\\Marlev\\Component\\Tmarlevv2'));

        $container->set(
            ComponentInterface::class,
            function (Container $container)
            {

                $component = new Tmarlevv2Component($container->get(ComponentDispatcherFactoryInterface::class));

                $component->setRegistry($container->get(Registry::class));
                $component->setMVCFactory($container->get(MVCFactoryInterface::class));
                //$component->setCategoryFactory($container->get(CategoryFactoryInterface::class));
                $component->setAssociationExtension($container->get(AssociationExtensionInterface::class));
                $component->setRouterFactory($container->get(RouterFactoryInterface::class));

                return $component;
            }
        );
    }
};