
<?php
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\HTMLHelper;
//for_use

/**
 * @package		Joomla.Site
 * @subpackage	mod_login
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */
// no direct access
defined('_JEXEC') or die;
HtmlHelper::_('behavior.keepalive');
?>
<?php if ($type == 'logout') : ?>
    <form action="<?php echo Route::_('index.php', true, $params->get('usesecure')); ?>" method="post" id="login-form">
    <?php if ($params->get('greeting')) : ?>
            <div class="login-greeting">
            <?php
            if ($params->get('name') == 0) : {
                    echo Text::sprintf('MOD_LOGIN_HINAME', htmlspecialchars($user->get('name')));
                } else : {
                    echo Text::sprintf('MOD_LOGIN_HINAME', htmlspecialchars($user->get('username')));
                } endif;
            ?>
            </div>
        <?php endif; ?>
        <div class="logout-button">
            <input type="submit" name="Submit" class="btn btn-inverse" value="<?php echo Text::_('JLOGOUT'); ?>" />
            <input type="hidden" name="option" value="com_users" />
            <input type="hidden" name="task" value="user.logout" />
            <input type="hidden" name="return" value="<?php echo $return; ?>" />
            <?php echo HtmlHelper::_('form.token'); ?>
        </div>
    </form>
<?php else : ?>
    <form action="<?php echo Route::_('index.php', true, $params->get('usesecure')); ?>" method="post" id="login-form" >
        <?php if ($params->get('pretext')): ?>
            <div class="pretext">
                <p><?php echo $params->get('pretext'); ?></p>
            </div>
        <?php endif; ?>
        <fieldset class="userdata">
            <p id="form-login-username">
                <label for="modlgn-username"><?php echo Text::_('MOD_LOGIN_VALUE_USERNAME') ?></label>
                <input id="modlgn-username" type="text" name="username" class="inputbox"  size="18" placeholder="<?php echo Text::_('MOD_LOGIN_VALUE_USERNAME') ?>"/>

                <a class="hasTooltip btn  login-button"   href="<?php echo Route::_('index.php?option=com_users&view=remind'); ?>" title="<?php echo Text::_('MOD_LOGIN_FORGOT_YOUR_USERNAME'); ?>">
                    <span class="icon-user"> </span>
                </a>
            </p>
            <p id="form-login-password">
                <label for="modlgn-passwd"><?php echo Text::_('JGLOBAL_PASSWORD') ?></label>
                <input id="modlgn-passwd" type="password" name="password" class="inputbox" size="18" placeholder="<?php echo Text::_('JGLOBAL_PASSWORD') ?>" />

                <a class="hasTooltip btn login-button"   href="<?php echo Route::_('index.php?option=com_users&view=reset'); ?>" title="<?php echo Text::_('MOD_LOGIN_FORGOT_YOUR_PASSWORD'); ?>">
                    <span class="icon-lock "> </span>
                </a>
            </p>

            <?php if (PluginHelper::isEnabled('system', 'remember')) : ?>
                <div id="form-login-remember">
                    <label for="modlgn-remember"><?php echo Text::_('MOD_LOGIN_REMEMBER_ME') ?></label>
                    <input id="modlgn-remember" type="checkbox" name="remember" class="inputbox" value="yes"/>
                    <div class="clearfix"></div>
                </div>
            <?php endif; ?>
            <div class="ml-loginmodule-register" >
                <input type="submit" name="Submit" class="btn btn-inverse login-button-margin" value="<?php echo Text::_('JLOGIN') ?>" />
                <?php
                $usersConfig = ComponentHelper::getParams('com_users');
                if ($usersConfig->get('allowUserRegistration')) :
                    ?>

                    <a class="btn btn-light" href="<?php echo Route::_('index.php?option=com_users&view=registration'); ?>" >
                    <?php echo Text::_('MOD_LOGIN_REGISTER'); ?></a>

    <?php endif; ?>

            </div>

            <input type="hidden" name="option" value="com_users" />
            <input type="hidden" name="task" value="user.login" />
            <input type="hidden" name="return" value="<?php echo $return; ?>" />

    <?php echo HtmlHelper::_('form.token'); ?>
        </fieldset>




    <?php if ($params->get('posttext')): ?>
            <div class="posttext">
                <p><?php echo $params->get('posttext'); ?></p>
            </div>
    <?php endif; ?>
    </form>
<?php endif; ?>