
<?php
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
//for_use

/**
 * @extension       Marlev Template
 * @author          Lev Milicenco<support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2013 marlev.it All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
defined('_JEXEC') or die;
$getlang = Factory::getApplication()->getLanguage();
?>

<div class="tm-contactprivacy tm-config">


    <h3><?php echo Text::_("TPL_MARLEV_CONTACT_PRIVACY"); ?> & antispam</h3>
    <div class="slide-config-title">
        <?php echo Text::_("TPL_MARLEV_CONTACT_PRIVACY_INTRO"); ?>

    </div>
    <?php echo $this->form->renderField("enable_antispam"); ?>

    <div class="control-group">
        <div class="control-label">
            <?php echo $this->form->getLabel('cookie_deflang'); ?>
        </div>
        <div class="controls">

            <select id="params_cookie_deflang" name="params[contactprivacy_deflang]">
                <?php

                foreach ($this->lang_params->langs as $lang):
                    $lang->lang_code = $lang->lang_code;
                    ?>
                    <option <?php if ((isset($this->lang_params->params["contactprivacy_deflang"]) && $this->lang_params->params["contactprivacy_deflang"] == $lang->lang_code)) echo 'selected="selected"'; ?>
                            value="<?php echo $lang->lang_code; ?>"><?php echo $lang->title; ?></option>
                <?php
                endforeach;
                ?>
            </select>
            <div >
                <small class="form-text"><?php echo Text::_('TPL_MARLEV_COOKIE_DEFAULT_LANG_DESC')?></small>
            </div>
        </div>


    </div>

    <div id="contact-privacy-config" class="tabs-config">
        <?php echo HtmlHelper::_('uitab.startTabSet', 'contactprivacytab', array('active' => 'contactprivacy-' . $getlang->getTag())); ?>
        <?php
        foreach ($this->lang_params->langs as $key):
            $key->lang_code = $key->lang_code;
            $contacttitle = "";
            if (isset($this->lang_params->params['contacttitle_' . $key->lang_code])) {
                $contacttitle = $this->lang_params->params['contacttitle_' . $key->lang_code];
            }
            echo HtmlHelper::_('uitab.addTab', 'contactprivacytab', 'contactprivacy-' . $key->lang_code, $key->title);
            ?>
            <div class="slide-config-title">
                <strong><?php echo Text::_("COM_TMARLEV_CONFIGURAZIONE_ERRORPAGE_PER") . " " . $key->title; ?></strong>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <label class="hasPopover"
                           data-content="<?php echo Text::_("TPL_MARLEV_SELECT_CONTACT_CHECKBOX") ?>">
                        <?php echo Text::_("TPL_MARLEV_SELECT_CONTACT_CHECKBOX") ?>
                    </label>
                </div>
                <div class="controls">
                    <select
                            name="params[contactprivacy_checkbox_<?php echo $key->lang_code ?>]">
                        <option
                                value="0"><?php echo Text::_('COM_TMARLEV_NONE') ?></option>
                        <?php
                        foreach ($this->contact_privacy as $c_privacy):
                            $selected_check = "";
                            if (isset($this->lang_params->params['contactprivacy_checkbox_' . $key->lang_code]) && $this->lang_params->params['contactprivacy_checkbox_' . $key->lang_code] == $c_privacy->name) {
                                $selected_check = 'selected="selected"';
                            }
                            ?>
                            <option <?php echo $selected_check; ?>
                                    value="<?php echo $c_privacy->name ?>"><?php echo $c_privacy->title; ?></option>
                        <?php
                        endforeach;
                        ?>
                    </select>
                    <div >
                        <small class="form-text"><?php echo Text::_('SELECT_CHECKBOX_CONTACT_PRIVACY_DESK')?></small>
                    </div>
                </div>
            </div>

            <div class="control-group">
                <div class="control-label">
                    <label class="hasPopover"
                           data-content="<?php echo Text::_("TPL_MARLEV_CONTACT_WRITE_TEXT") ?>">
                        <?php echo Text::_("TPL_MARLEV_CONTACT_WRITE_TEXT") ?>
                    </label>
                </div>
                <div class="controls">
                    <input type="text" name="params[contacttitle_<?php echo $key->lang_code;?>]"  value="<?php echo $contacttitle;?>" class="form-control tm-text" >
                    <div >
                        <small class="form-text"><?php echo Text::_('TPL_MARLEV_CONTACT_WRITE_TEXT_DESK')?></small>
                    </div>
                </div>
            </div>

            <div class="control-group">
                <div class="control-label">
                    <label class="hasPopover"
                           data-content="<?php echo Text::_("TPL_MARLEV_CONTACT_SELECT_ARTICLE") ?>">
                        <?php echo Text::_("TPL_MARLEV_CONTACT_SELECT_ARTICLE") ?>
                    </label>
                </div>
                <div class="controls">
                    <select
                            name="params[contactprivacy_article_<?php echo $key->lang_code ?>]">
                        <option
                                value="0"><?php echo Text::_('COM_TMARLEV_NONE') ?></option>
                        <?php
                        foreach ($this->contact_privacy_article as $c_privacy_article):
                            $selected_check = "";
                            if (isset($this->lang_params->params['contactprivacy_article_' . $key->lang_code]) && $this->lang_params->params['contactprivacy_article_' . $key->lang_code] == $c_privacy_article->id) {
                                $selected_check = 'selected="selected"';
                            }
                            ?>
                            <option <?php echo $selected_check; ?>
                                    value="<?php echo $c_privacy_article->id ?>"><?php echo $c_privacy_article->title; ?></option>
                        <?php
                        endforeach;
                        ?>
                    </select>
                    <div >
                        <small class="form-text"><?php echo Text::_('TPL_MARLEV_CONTACT_SELECT_ARTICLE_DESK')?></small>
                    </div>
                </div>
            </div>
            <div class="clearfix"></div>
            <?php echo HtmlHelper::_('uitab.endTab'); ?>
        <?php endforeach; ?>
        <?php echo HtmlHelper::_('uitab.endTabSet'); ?>

    </div>
    <div class="clearfix"></div>
</div>

