<?php
namespace Marlev\Component\Tmarlevv2\Administrator\Helper;
/**
 *
 * @extension       T-Marlev
 * @author          Lev Milicenco<support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2022 marlev.it All Rights Reserved

 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

use Joomla\CMS\Factory;
//for_use
defined('_JEXEC') or die;


class layout_presaved
{
    public $id;
    public $layout;
    protected $exist_layout;
    protected $devices;
    protected $default_keys;

    function __construct($id, $layout)
    {
        $this->layout = $layout;
        $this->id = $id;
        $this->exist_layout = $this->get_exists_layout();
        $this->devices = ["pc", "tablet", "mobile"];
        $this->default_keys = ["", "order", "hide", "offset", "addclear"];
        $this->empty_array_layout_creator();
        $this->empty_array_css_creator();
    }

    protected function css_for_sections()
    {
        if (isset($this->layout["sections"]) && count($this->layout["sections"]) > 0) {
            foreach ($this->layout["sections"] as $ps => $section) {
                $section = trim($section);
                foreach ($this->devices as $td => $device) {
                    if (!isset($this->layout["css"][$device][$section]) && isset($this->exist_layout['css']->$device->$section)) {
                        $this->layout["css"][$device][$section] = (array)$this->exist_layout['css']->$device->$section;
                    }
                }
            }
        }
    }

    protected function css_for_positions($position)
    {
        foreach ($this->devices as $td => $device) {
            if (!isset($this->layout["css"][$device][$position]) && isset($this->exist_layout['css']->$device->$position)) {
                $this->layout["css"][$device][$position] = (array) $this->exist_layout['css']->$device->$position;
            }
        }
    }


    public function assigner()
    {
        $this->css_for_sections();
        if (isset($this->layout["positions"]) && count($this->layout["positions"]) > 0) {
            foreach ($this->layout["positions"] as $ps => $block_positions) {
                $positions = explode(",", $block_positions);
                if (is_array($positions)) {
                    foreach ($positions as $key_pos => $position) {
                        //per pc tablet mobile
                        foreach ($this->default_keys as $pre => $prefix) {
                            $this->position_assigner($position, $prefix);
                        }
                        //css per positions
                        $this->css_for_positions($position);
                    }
                }

            }
        }
        return $this->layout;
    }

    protected function position_assigner($position, $prefix = "")
    {

        foreach ($this->devices as $key => $device) {
            $device = $prefix . $device;
            if (!isset($this->layout[$device][$position]) && isset($this->exist_layout[$device]->$position)) {
                $this->layout[$device][$position] = $this->exist_layout[$device]->$position;
            }
        }

    }

    //Crea array per vuoto per css se non esiste in layout
    protected function empty_array_css_creator()
    {
        if (!isset($this->layout['css'])) {
            $this->layout['css'] = array();
        }
        foreach ($this->devices as $t => $device) {
            if (!isset($this->layout['css'][$device])) {
                $this->layout['css'][$device] = array();
            }
        }
    }

    //Crea array per vuoto se non esiste in layout
    protected function empty_array_layout_creator()
    {
        foreach ($this->devices as $t => $device) {
            foreach ($this->default_keys as $dk => $key) {
                if (!isset($this->layout[$key . $device])) {
                    $this->layout[$key . $device] = array();
                }
            }
        }
    }

    protected function get_exists_layout()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('layout,id');
        $query->from('#__tmarlevv2_layout');
        $query->where('tid=' . $db->Quote($this->id));
        $db->setQuery($query);
        $get_layout = $db->loadObjectList();
        $layout = (array)json_decode($get_layout[0]->layout);
        return $layout;
    }
}