
<?php
use Joomla\CMS\Factory;
//for_use


/**
 * @package     Joomla.Site
 * @subpackage  com_contact
 *
 * @copyright   (C) 2006 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

HTMLHelper::_('behavior.keepalive');
HTMLHelper::_('behavior.formvalidator');
//Marlev contact
$app = Factory::getApplication();
$template = $app->getTemplate(true);
marlev_load_langs($template->template);
$deflang = $template->params->get('contactprivacy_deflang', 0);
$get_checkbox = $template->params->get('contactprivacy_checkbox_' . $app->getLanguage()->getTag(), '0');
$get_article_id = $template->params->get('contactprivacy_article_' . $app->getLanguage()->getTag(), false);
if ($get_article_id == false) {
    $get_article_id = $template->params->get('contactprivacy_article_' . $deflang, false);
}
$get_title = $template->params->get('contacttitle_' . $app->getLanguage()->getTag(), false);
if ($get_title == false) {
    $get_title = $template->params->get('contacttitle_' . $deflang, Text::_("TPL_TRATTAMENTO_DATI_PRIVACY"));
}
if ($get_checkbox == '0') {
    $get_checkbox = $template->params->get('contactprivacy_checkbox_' . $deflang, '0');
}
if ($get_checkbox != '0') {
    $get_checkbox = trim(str_replace("-", "_", $get_checkbox));
    $finder = '/(<label.{0,}for="jform_com_fields_' . $get_checkbox . '0".{0,}<\/label>)/isU';
    $replace = '$1 <span  data-bs-target="#trattamento_show"
     data-bs-toggle="modal" style="color:#286090;cursor: pointer;">' . $get_title . '</span> ';

}

?>
    <div class="com-contact__form contact-form">
        <form id="contact-form" action="<?php echo Route::_('index.php'); ?>" method="post"
              class="form-validate form-horizontal well">
            <?php foreach ($this->form->getFieldsets() as $fieldset) :  ?>
                <?php if ($fieldset->name === 'captcha' && $this->captchaEnabled) : ?>
                    <?php continue; ?>
                <?php endif; ?>
                <?php $fields = $this->form->getFieldset($fieldset->name); ?>
                <?php if (count($fields)) : ?>
                    <fieldset class="m-0">
                        <?php if (isset($fieldset->label) && ($legend = trim(Text::_($fieldset->label))) !== '') : ?>
                            <legend><?php echo $legend; ?></legend>
                        <?php endif; ?>
                        <?php
                        //Marlev Here
                        $i = 0;
                        //end
                        foreach ($fields as $field) : ?>
                            <?php
                            //Marlev here Antispam
                            $i++;
                            if ($template->params->get('enable_antispam', 1) == 1 && $i == 3) : ?>
                                <div class="control-group" id="jformlastname">
                                    <div class="control-label"><label id="jform_com_fields_jformlastname-lbl"
                                                                      for="jform_com_fields_jformlastname">
                                            Last Name</label>
                                    </div>
                                    <div class="controls">

                                        <fieldset id="jform_com_fields_jformlastname">
                                            <legend class="visually-hidden">Last Name</legend>
                                            <div class="form-input form-check-inline">
                                                <input type="text" name="jform[formlastname]" id="form-lastname"
                                                       value="" size="30" class="form-control"/>
                                            </div>
                                        </fieldset>
                                    </div>
                                </div>
                            <?php endif;
                            //End Marlev
                            ?>
                            <?php
                            //Marlev here
                            if ($get_checkbox != 0) {
                                if (preg_match($finder, $field->renderField())) {
                                    $get_field = $field->renderField();
                                } else {
                                    echo $field->renderField();
                                }

                            } else {
                                echo $field->renderField();
                            }
                            //end marlev
                            ?>
                        <?php endforeach; ?>
                        <?php
                        //Marlev here
                        if (isset($get_field)) {
                            echo preg_replace($finder, $replace, $get_field);
                        }
                        //end marlev
                        ?>
                    </fieldset>
                <?php endif; ?>
            <?php endforeach; ?>
            <?php if ($this->captchaEnabled) : ?>
                <?php echo $this->form->renderFieldset('captcha'); ?>
            <?php endif; ?>
            <div class="control-group">
                <div class="controls">
                    <button class="btn btn-primary validate"
                            type="submit"><?php echo Text::_('COM_CONTACT_CONTACT_SEND'); ?></button>
                    <input type="hidden" name="option" value="com_contact">
                    <input type="hidden" name="task" value="contact.submit">
                    <input type="hidden" name="return" value="<?php echo $this->return_page; ?>">
                    <input type="hidden" name="id" value="<?php echo $this->item->slug; ?>">
                    <?php echo HTMLHelper::_('form.token'); ?>
                </div>
            </div>
        </form>
    </div>
<?php
//Marlev here
if ($get_checkbox != '0') {
    echo showModalContent(ucfirst($get_title), "trattamento_show", marlevContactPrivacyArticles($get_article_id));
}
function marlevContactPrivacyArticles($get_article_id)
{
    if ($get_article_id == false) {
        return "";
    }
    $db = Factory::getDbo();
    $query = $db->getQuery(true);
    $query->select('introtext ');
    $query->from('#__content');
    $query->where('id=' . (int)$get_article_id);
    $db->setQuery($query);
    return $db->loadResult();
}

function marlev_load_langs($extension)
{
    $lang = Factory::getApplication()->getLanguage();
    $base_dir = JPATH_SITE . '/templates/' . $extension . '/';
    $reload = true;
    $lang->load("tpl_" . $extension, $base_dir, $lang->get("tag"), $reload);
}

function showModalContent($title, $id, $content)
{
    return HTMLHelper::_(
        'bootstrap.renderModal',
        $id,
        array(
            'title' => $title,
//                 'modalWidth'  => '60',
            'height' => '600px',
            'width' => '400px',
            'footer' => '<button type="button" class="btn btn-secondary" data-bs-dismiss="modal" aria-hidden="true">'
                . Text::_('JLIB_HTML_BEHAVIOR_CLOSE') . '</button>'
        ),
        $content
    );
} ?>