<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_templates
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
require_once JPATH_ROOT . '/administrator/components/com_tmarlevv2/src/Helper/loader.php';
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
//for_use
defined('_JEXEC') or die;
use Joomla\CMS\Layout\LayoutHelper;
// Initiasile related data.
require_once JPATH_ADMINISTRATOR . '/components/com_menus/helpers/menus.php';
$menuTypes = MenusHelper::getMenuLinks();
$user = Factory::getApplication()->getIdentity();
?>
<div class="tm-assigned tm-config">
    <h3><?php echo Text::_("COM_TMARLEV_ASSIGNED_MENU");?></h3>

    <div class=" row">
        <div class="col-sm-12">
            <label id="jform_menuselect-lbl" for="jform_menuselect"><?php echo Text::_('JGLOBAL_MENU_SELECTION'); ?></label>
            <div class="btn-toolbar">
                <button class="btn" type="button" class="jform-rightbtn" onclick="jQuery('.chk-menulink').attr('checked', !jQuery('.chk-menulink').attr('checked'));">
                    <i class="icon-checkbox-partial"></i> <?php echo Text::_('JGLOBAL_SELECTION_INVERT'); ?>
                </button>
            </div>
        </div>



            <?php foreach ($menuTypes as &$type) : ?>
                <div class="col-3 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
                    <div class="thumbnail">
                        <button class="btn" type="button" class="jform-rightbtn" onclick="jQuery('.<?php echo $type->menutype; ?>').attr('checked', !jQuery('.<?php echo $type->menutype; ?>').attr('checked'));">
                            <i class="icon-checkbox-partial"></i> <?php echo Text::_('JGLOBAL_SELECTION_INVERT'); ?>
                        </button>
                        <h5><?php echo $type->title ? $type->title : $type->menutype; ?></h5>
                        <span class="checkbox checkbox-primary checkbox-assignment">
                            <?php foreach ($type->links as $link) : ?>

                                <input type="checkbox" name="jform[assigned][]" value="<?php echo (int) $link->value; ?>" id="link<?php echo (int) $link->value; ?>"<?php if ($link->template_style_id == $this->load->id): ?> checked="checked"<?php endif; ?><?php if ($link->checked_out && $link->checked_out != $user->id): ?> disabled="disabled"<?php else: ?> class="chk-menulink <?php echo $type->menutype; ?>"<?php endif; ?> />
                                <label for="link<?php echo (int) $link->value; ?>" >
                                    <?php //echo $link->text; ?>
                                    <?php echo LayoutHelper::render('joomla.html.treeprefix', array('level' => $link->level)) . $link->text; ?>
                                </label><br/>
                            <?php endforeach; ?>
                        </span>
                    </div>
                </div>
            <?php endforeach; ?>

        </div>
        <div class="clearfix"></div>

    <div class="clearfix"></div>
</div>