
<?php
require_once JPATH_ADMINISTRATOR . '/components/com_tmarlevv2/src/Helper/saveLayout.php';
use Marlev\Component\Tmarlevv2\Administrator\Helper\mlfront_helper as mltemplate;
use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
//for_use


/**
 * @extension       Marlev Templates
 * @author          Lev Milicenco <support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2015 marlev.it All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 *
 */



defined('_JEXEC') or die;


class ml_template_render
{

    public $position;
    public $clearfix;
    public $getlayout;
    public $tlayout;
    public $logo;
    public $baseurl;
    public $template;

    public $prepare_view;
    public $document;
    public $error;
    public $htmldoc;
    public $params;
    public $lang;


    function __construct($getlayout, $tlayout, $logo, $params, $baseurl, $template, $error)
    {
        $this->getlayout = $getlayout;
        $this->tlayout = $tlayout;
        $this->params = $params;
        $this->baseurl = $baseurl;
        $this->template = $template;
        $this->logo = $logo;
        $this->lang = Factory::getLanguage()->getTag();
        $this->htmldoc = Factory::getApplication()->getDocument();


        $this->error = $error;
    }

    function render()
    {
        $cookie_position = ml_template_helper::cookie_helper($this->params, $this->template);
        ml_template_helper::show_cookie($this->params, $cookie_position, "top");
        if ($this->error === true) {
            $positions_modules = $this->prepare_module_error();
        } else {
            //$modules = ModuleHelper::getModuleList();
            $positions_modules = ml_template_helper::smista_modules($this->tlayout, $this->getlayout->defaultpositions);
        }
        $positions_modules = $this->render_social($positions_modules);
        $positions_modules->positions = array_merge($positions_modules->positions, array("logo", "content"));

	$loadtheme = new mltemplate;

	$this->prepare_view = $loadtheme->prepare_view($this->getlayout->load, $this->template);
        if (!in_array("copyright", $positions_modules->positions) && $this->params->get('brand') == 1) {
            $positions_modules->positions[] = "copyright";
        }

        foreach ($this->getlayout->sections as $key => $getpos) {

            echo '<div id="' . $key . '_section" >';

            foreach ($getpos as $gpos => $positions_block) {

                if (isset($this->tlayout['suspended'][$positions_block])) {
                    continue;
                }
                $getpositions = (isset($this->tlayout['positions'][$positions_block])) ? $this->trim_explode(",", $this->tlayout['positions'][$positions_block]) : array();
                $positions = array();
                foreach ($getpositions as $key => $defpos) {
                    if (in_array($defpos, $positions_modules->positions)) {
                        $positions[] = $defpos;
                    }
                }
                echo $this->view($positions, $positions_block, $positions_modules->modules);
            }
            echo '<div class="clearfix"></div></div>';
            echo '<div class="clearfix"></div>';
        }


        echo $this->show_fixed_social($positions_modules->positions);
        echo $this->to_up();
        ml_template_helper::show_cookie($this->params, $cookie_position, "bottom");
    }

    protected function prepare_module_error()
    {

        $curlang = $this->lang;
        $deflang = $this->params->get('errorpage_deflang');
        $get_modules_lang = $this->params->get('errormodules_' . $curlang, false); //$this->lang
        $get_modules_default = $this->params->get('errormodules_' . $deflang, false);


        if ($get_modules_lang) {
            $showed_modules = ml_template_helper::prepare_module_error_helper($get_modules_lang, $this->getlayout->defaultpositions);
        } else if ($get_modules_default) {
            $showed_modules = ml_template_helper::prepare_module_error_helper($get_modules_default, $this->getlayout->defaultpositions);
        } else {
            $showed_modules = new \stdClass();
            $showed_modules->positions = $this->getlayout->defaultpositions;
            $showed_modules->ids = false;
        }
        $modules = ml_template_helper::get_Modules($showed_modules->ids);
        $showed_modules->modules = ml_template_helper::smista_modules_error($modules, $showed_modules->positions);
        return $showed_modules;
    }

    protected function view($positions, $positions_block, $modules)
    {
        $return = "";
        $return_html = '';


        foreach ($positions as $gv => $position) {
            if (!$position) {
                continue;
            }

            $this->position = $position;
            $div = $this->container_div();
            switch ($position) {
                case "logo":
                    $return_html .= $this->show_logo($div);
                    break;
                case "menu":
                    $return_html .= $this->show_menu($div, $modules);
                    break;
                case "content":
                    $return_html .= $this->show_content($modules);
                    break;
                case "copyright":
                    $return_html .= $this->show_copyright($div, $modules);
                    break;
                case "breadcrumbs":
                    $return_html .= $this->show_breadcrumb($div, $modules);
                    break;
                case "breadcrumbs-bottom":
                    $return_html .= $this->show_breadcrumb($div, $modules);
                    break;
                default:
                    $return_html .= $this->show_default($div, $modules);
            }
        }
        if (!empty($return_html)) {
            $return = '<div id="' . $positions_block . '_subsection" >';
            $return .= '<div class="' . (isset($this->tlayout['width'][$positions_block])?$this->tlayout['width'][$positions_block]:"" ). '">';
            $return .= '<div class="row">';
            $return .= $return_html;
            $return .= '</div>';
            $return .= '<div class="clearfix"></div></div></div>';
        }
        return $return;
    }

    protected function container_div()
    {
        $return = new \stdClass();
        $get_class = $this->genera_classes();
        $get_effects = $this->genera_effects();

        $return->opendiv = '<div  class="' . $get_class . '" >'
            . '<div id="' . $this->position . '" class="' . $get_effects->class . '"' . $get_effects->data_effects . ' ' . $get_effects->data_delay . '>';
        $return->closediv = '<div class="clearfix"></div></div></div>';
        $return->closediv .= $this->elabora_clearfix();
        return $return;
    }

    protected function elabora_clearfix()
    {

        $divs = $this->assign_clearfix("pc", "w-100 gy-2 d-none d-lg-block");
        $divs .= $this->assign_clearfix("tablet", "w-100 gy-2 d-none d-md-block d-lg-none");
        $divs .= $this->assign_clearfix("mobile", "w-100 gy-2 d-block d-sm-none");

        return $divs;
    }

    protected function assign_clearfix($device, $css_class)
    {
        if (isset($this->tlayout['addclear' . $device][$this->position]) && $this->tlayout['addclear' . $device][$this->position] == 1) {
            return '<div class="' . $css_class . '"></div>';
        } else {
            return '';
        }
    }

    protected function genera_classes()
    {

        $return = ' col-' . $this->tlayout['mobile'][$this->position] . ' col-sm-' . $this->tlayout['mobile'][$this->position] . ' col-md-' . $this->tlayout['tablet'][$this->position] . ' col-lg-' . $this->tlayout['pc'][$this->position] . '  col-xl-' . $this->tlayout['pc'][$this->position] . ' col-xxl-' . $this->tlayout['pc'][$this->position];
        //hide
        if (isset($this->tlayout['hidepc'][$this->position])) {
            $return .= ' ' . $this->tlayout['hidepc'][$this->position] . ' ' . $this->tlayout['hidetablet'][$this->position] . ' ' . $this->tlayout['hidemobile'][$this->position] . ' ';
        }
        echo $this->prepare_view;

	//if ($this->tlayout['pc'][$this->position] < 12) {
        $return .= ' ' . $this->tlayout['offsetpc'][$this->position] . ' ' . $this->tlayout['orderpc'][$this->position]; //. ' ' . $this->tlayout['pushpc'][$this->position];
        //}
        //   if ($this->tlayout['tablet'][$this->position] < 12) {
        $return .= ' ' . $this->tlayout['offsettablet'][$this->position] . ' ' . $this->tlayout['ordertablet'][$this->position];//. ' ' . $this->tlayout['pushtablet'][$this->position];
        //}
        $this->prepare_view = "";

	//  if ($this->tlayout['mobile'][$this->position] < 12) {
        $return .= ' ' . $this->tlayout['offsetmobile'][$this->position] . ' ' . $this->tlayout['ordermobile'][$this->position]; //. ' ' . $this->tlayout['pushmobile'][$this->position] . ' ';
        //}
        return $return;
    }

    protected function genera_effects()
    {
        $returnstd = new \stdClass();
        $returnstd->data_effects = '';
        $returnstd->data_delay = '';
        $returnstd->class = '';
        $return = '';

        //$delay = '';
        if (isset($this->tlayout["css"]["pc"][$this->position]['effect'])) {
            $return .= ' ' . $this->tlayout["css"]["pc"][$this->position]['effect'];
            $returnstd->data_delay .= 'data-delaypc="' . $this->tlayout["css"]["pc"][$this->position]['efdelay'] . '"';
        }
        if (isset($this->tlayout["css"]["tablet"][$this->position]['effect'])) {
            $return .= ' ' . $this->tlayout["css"]["tablet"][$this->position]['effect'];
            $returnstd->data_delay .= ' data-delaytablet="' . $this->tlayout["css"]["tablet"][$this->position]['efdelay'] . '"';
        }
        if (isset($this->tlayout["css"]["mobile"][$this->position]['effect'])) {
            $return .= ' ' . $this->tlayout["css"]["mobile"][$this->position]['effect'];
            $returnstd->data_delay .= ' data-delaymobile="' . $this->tlayout["css"]["mobile"][$this->position]['efdelay'] . '"';
        }
        if (!empty($return)) {
            $returnstd->data_effects = ' data-mleffect="' . $return . '"';
            $returnstd->class = 'ml-effect-true ';
        }

        return $returnstd;
    }

    /*
     *
     *
     *
     * Show copyright
     */

    protected function show_copyright($div, $modules)
    {
        $return_html = "";

        if (isset($modules[$this->position][0]) || $this->params->get('brand') == 1) {
            $return_html .= $div->opendiv;
            if (isset($modules[$this->position][0])) {
                foreach ($modules[$this->position] as $module) {

                    $return_html .= ModuleHelper::renderModule($module, array("style" => "moduletable"));
                }
            }
            if ($this->params->get('brand') == 1) {
                $return_html .= '<div class="clearfix"></div><div class="biged"><a href="' . $this->show_default_param('linkcopy', "https://marlev.it/") . '" target="_blank">' . $this->show_default_param('copy', "Designed by Marlev.it") . '</a></div>';
            }
            $return_html .= "";
            $return_html .= $div->closediv;
        }
        return $return_html;
    }

    protected function show_breadcrumb($div, $modules)
    {
        $return_html = "";
        if (isset($modules[$this->position][0])) {
            $return_html .= $div->opendiv;
            foreach ($modules[$this->position] as $module) {
                $return_html .= ModuleHelper::renderModule($module, array("style" => 'none'));
            }
            $return_html .= $div->closediv;
        }
        return $return_html;
    }

    /*
     *
     *
     *
     * show default module
     */

    protected function show_default($div, $modules)
    {
        $return_html = "";
        if (isset($modules[$this->position][0])) {
            //$return_html .= $div->opendiv;
            foreach ($modules[$this->position] as $module) {
                if ($module->module == "mod_marlevsocial") {
                    $return_html .= $module->content;
                } else {
                    $return_html .= ModuleHelper::renderModule($module, array("style" => 'moduletable'));
                }
            }
        }
        return ($return_html != '')?$div->opendiv . $return_html . $div->closediv :'';
    }

    /*
     *
     *
     *
     * AShow content
     */

    protected function show_content($modules)
    {
        $inners = $this->get_inners();
        $this->fix_content_if_not_right_left($modules);
        $div = $this->container_div();
        $return_html = $div->opendiv;
        $return_html .= $this->load_inners($inners->innertop, $modules);
        if ($this->error === true) {
            $deflang = $this->params->get('errorpage_deflang');
            $get_content_lang = $this->params->get('errortext_' . $this->lang, false); //$this->lang
            $get_content_default = $this->params->get('errortext_' . $deflang, false);

            if ($get_content_lang) {
                $return_html .= '<div style="min-height:300px">' . $get_content_lang . '</div>';
            } elseif ($get_content_default) {
                $return_html .= '<div style="min-height:300px">' . $get_content_default . '</div>';
            } else {
                $return_html .= '<div style="text-align:center"><img src="' . $this->baseurl . '/templates/' . $this->template . '/images/404.png" width="700" alt=""/></div>';
            }
        } else {
            $return_html .= '<jdoc:include type="message" />';
            $return_html .= '<jdoc:include type="component" />';
            $return_html .= '<div class="clearfix"></div>';
        }
        $return_html .= $this->load_inners($inners->innerbottom, $modules);

        $return_html .= $div->closediv;
        return $return_html;
    }

    /*
     *
     *
     *
     * elabora parametri da params e mette quelli di default
     */

    protected function show_default_param($param, $default)
    {
        if ($this->params->get($param) == true) {
            return htmlspecialchars($this->params->get($param));
        }
        return $default;
    }

    /*
     *
     *
     *
     * Show logo
     */

    protected function show_logo($div)
    {
        $return_html = $div->opendiv;
        $return_html .= '<div id="ml-logo"><a href="' . $this->baseurl . '"><img src="' . $this->logo . '" alt="' . htmlspecialchars($this->params->get('sitetitle')) . '" '
            . 'width="' . $this->show_default_param('logo-width', 216) . '" height="' . $this->show_default_param('logo-height', 45) . ''
            . '" style="margin-top: ' . $this->show_default_param('logo-margin-top', 7) . 'px; margin-left:' . $this->show_default_param('logo-margin-left', 0) . 'px;"/></a></div>';
        $return_html .= $div->closediv;
        return $return_html;
    }

    /*
     *
     *
     *
     * Show main menu
     */

    protected function show_menu($div, $modules)
    {
        $return_html = $div->opendiv;
        //form abstract only additional class d-flex justify-content-center
        $return_html .= '<div id="ml-navigation-menu" class="d-none d-lg-block d-xl-block d-xxl-block" ><div class="d-flex justify-content-center">';
        if (isset($modules[$this->position][0])) {
            foreach ($modules[$this->position] as $module) {
                $module->style = "none";
                $return_html .= ModuleHelper::renderModule($module, array("style" => "none", "class" => " justify-content-center"));
            }
        }
        $return_html .= '<div class="clearfix"></div></div></div>';
        $return_html .= $div->closediv;
        $return_html .= '<div class="col-12 p-0 d-block d-lg-none d-xl-none d-xxl-none">';
        $return_html .= $this->show_menu_endhtml();
        $return_html .= '</div>';

        return $return_html;
    }

    /*
     *
     *
     *
     * Fix cols in content if right & left
     */

    protected function fix_content_if_not_right_left($modules)
    {
        $devices = array("pc", "tablet", "mobile");
        if (!$this->htmldoc->countModules("left",true ) && !$this->htmldoc->countModules("right",true )) {

            foreach ($devices as $key => $value) {
                $this->tlayout[$value][$this->position] = 12;
            }
        } elseif ($this->htmldoc->countModules("left",true ) && !$this->htmldoc->countModules("right",true )) {
            foreach ($devices as $key => $value) {
                $count = $this->tlayout[$value][$this->position] + $this->tlayout[$value]["left"];
                if ($count < 12) {
                    $this->tlayout[$value][$this->position] = 12 - $this->tlayout[$value]["left"];
                }
            }
        } elseif ($this->htmldoc->countModules("right",true ) && !$this->htmldoc->countModules("left",true )) {
            foreach ($devices as $key => $value) {
                $count = $this->tlayout[$value][$this->position] + $this->tlayout[$value]["right"];
                if ($count < 12) {
                    $this->tlayout[$value][$this->position] = 12 - $this->tlayout[$value]["right"];
                }
            }
        }
    }

    /*
     *
     *
     *
     * Get inners
     */

    protected function get_inners()
    {
        $return = new \stdClass();

        $return->innertop = false;
        $return->innerbottom = false;

        if (!isset($this->getlayout->positions[$this->position]))
            return $return;

        $poslayout = $this->getlayout->positions[$this->position];
        if (isset($poslayout['innertop'])) {
            $return->innertop = $poslayout['innertop'];
        }
        if (isset($poslayout['innerbottom'])) {
            $return->innerbottom = $poslayout['innerbottom'];
        }

        return $return;
    }

    /*
     *
     *
     *
     * load inners
     */

    protected function load_inners($inner, $modules)
    {
        $return = '';
        if ($inner != false) {
            foreach ($inner as $ipos => $subpos) {
                if (isset($this->tlayout['suspended'][$subpos])) {
                    continue;
                }
                if (isset($this->tlayout['positions'][$subpos])) {
                    $innerpositions = $this->trim_explode(",", $this->tlayout['positions'][$subpos]);
                    $return .= $this->view($innerpositions, $subpos, $modules);
                }
            }
        }
        return $return;
    }

    protected function trim_explode($delimiter, $string)
    {
        $value = str_replace(" ", "", $string);
        return explode($delimiter, $value);
    }

    /*
     *
     *
     *
     * Show socials
     */

    protected function show_fixed_social($positions)
    {
        $social_fixed = ["socialleft" => true, "socialright" => true, "socialbottom" => true];
        $return_html = '';

        foreach ($positions as $key => $value) {
            if (isset($social_fixed[$value])) {

                $return_html .= $this->socialfixed($value);
            }
        }
        return $return_html;
    }

    protected function socialfixed($position)
    {

        $socials = $this->params->get("socials");
        if (empty($socials)) {
            return '';
        }
        $return_html = '<div class="ml-social-fixed ' . $position . '">';
        foreach ($socials['btns'] as $key => $value) {
            $return_html .= '<div class="social-fixed-' . $key . '">';
            $return_html .= self::out_icons_social($key, $value, $socials);
            $return_html .= '</div>';
        }

        $return_html .= '</div>';
        return $return_html;
    }

    protected function render_social($modules)
    {
        $social_positions = $this->params->get('socialpositions', false);
        if ($social_positions == false || in_array("null", $social_positions)) {
            return $modules;
        }
        $social = $this->get_social();
        if ($social == false) {
            return $modules;
        }
        foreach ($social_positions as $key => $value) {
            $modules->positions[] = $value;
            $modules->modules[$value][] = $social;
        }
        return $modules;
    }

    protected function get_social()
    {
        $socials = $this->params->get("socials");
        if (empty($socials)) {
            return false;
        }

        $return_html = "<div class='marlev-socials'><div class='card-body'>";
        foreach ($socials['btns'] as $key => $value) {
            $return_html .= self::out_icons_social($key, $value, $socials);
        }
        $return_html .= "</div></div>";
        $module = new \stdClass();
        $module->title = "";
        $module->module = "mod_marlevsocial";
        $module->position = "";
        $module->content = $return_html;
        $module->showtitle = 0;
        $module->params = '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}';
        return $module;
    }

    protected function out_icons_social($sname, $slink, $socials)
    {
        if ($this->params->get("socialtype") == "image") {
            $name = str_replace("social", "", $sname);
            $content = '<img src="' . $this->baseurl . '/templates/' . $this->template . '/images/' . $name . '.png"  width="35" height="34" alt="' . ucfirst($name) . '"  />';
        } else {
            $content = $socials['font'][$sname];
        }
        return '<a href="' . $slink . '" target="_blank" > ' . $content . '</a>';
    }

    /*
     *
     *
     *
     * Show end of main menu
     */

    protected function show_menu_endhtml()
    {
        $return_html = '<div id="ml-mobile-menu" class="d-block d-md-block d-lg-none d-xl-none d-xxl-none">'
            . '<div id="ml-mobile-menu-button"><i class="fa fa-bars" aria-hidden="true"></i>'
            . '</div>'
            . '<div id="ml-mobile-menu-box" class="menumobile moduletable_accordion" >'
            . '<div class="menumobile-block" >'
            . '<div class="container"><div class="row"><div class="col-9">'
            . '<div id="logo-mobile-menu"><a href="' . $this->baseurl . '"><img src="' . $this->logo . '" alt="' . $this->params->get('sitetitle' . "") . '" width="'.$this->show_default_param('logo-width', 216).'" height="'.$this->show_default_param('logo-height', 45).'" /></a></div>'
            . '</div>'
            . '<div class="col-3"><div id="close-marlev-mobile-box" >'
            . '<i id="close-marlev-mobile" class="fa fa-times " aria-hidden="true"></i>'
            . '</div></div></div></div><div class="clearfix"></div>'
            . '<div class="container"><div class="row"><div class="col-12">'
            . '<jdoc:include type="modules" name="' . $this->position . '"  style="none" />'
            . '</div></div></div>'
            . '</div>'
            . '</div>'
            . '</div>';
        return $return_html;
    }

    protected function to_up()
    {
        return '<div class="toup-closed" id="toup"><i class="fa fa-angle-double-up" aria-hidden="true"></i></div>';
    }

}

//    protected function show_menu($div) {
//        $return_html = $div->opendiv;
//        $return_html .= '<div id="ml-navigation-menu" class="hidden-xs hidden-xs" ><jdoc:include type="modules" name="' . $this->position . '"  style="none" /><div class="clearfix"></div></div>';
//        $return_html .= $this->show_menu_endhtml();
//        $return_html .= $div->closediv;
//        return $return_html;
//    }

//    protected function show_content() {
//        $inners = $this->get_inners();
//        $this->fix_content_if_not_right_left();
//        $div = $this->container_div();
//        $return_html = $div->opendiv;
//        $return_html .= '<jdoc:include type="message" />';
//        $return_html .= $this->load_inners($inners->innertop);
//        $return_html .= '<jdoc:include type="component" />';
//        $return_html .= $this->load_inners($inners->innerbottom);
//        $return_html .= $div->closediv;
//        return $return_html;
//    }

//    function error_page() {
//
//        $positions_modules = $this->prepare_module_error();
//
//        foreach ($this->getlayout->sections as $key => $getpos) {
//
//            echo '<div id="' . $key . '_section" >';
//
//            foreach ($getpos as $gpos => $positions_block) {
//                if (isset($this->tlayout['suspended'][$positions_block])) {
//                    continue;
//                }
//                $getpositions = $this->trim_explode(",", $this->tlayout['positions'][$positions_block]);
//                $positions = array();
//                foreach ($getpositions as $key => $defpos) {
//                    if (in_array($defpos, $positions_modules->positions)) {
//                        $positions[] = $defpos;
//                    }
//                }
//
//                echo $this->error_view($positions, $positions_block, $positions_modules->modules);
//            }
//            echo '</div>';
//        }
//    }


//    protected function view($positions, $positions_block) {
//        $return = "";
//        $return_html = '';
//
//
//        foreach ($positions as $gv => $position) {
//            if (!$position) {
//                continue;
//            }
//
//
//            $this->position = $position;
//            $div = $this->container_div();
//            switch ($position) {
//                case "logo":$return_html .= $this->show_logo($div);
//                    break;
//                case "menu":$return_html .= $this->show_menu($div);
//                    break;
//                case "content":$return_html .= $this->show_content();
//                    break;
//                case "copyright":$return_html .= $this->show_copyright($div);
//                    break;
//                case "socialbtn":$return_html .= $this->solciabtn($div);
//                    break;
//                default: $return_html .= $this->show_default($div);
//            }
//        }
//        if (!empty($return_html)) {
//            $return = '<div id="' . $positions_block . '_subsection" class="' . $this->tlayout['width'][$positions_block] . '" >';
//            $return .= $return_html;
//            $return .= '</div>';
//        }
//        return $return;
//    }


///shows functions
//    protected function show_copyright($div) {
//        $return_html = "";
//        $return_html .= $div->opendiv;
//        if (count(ModuleHelper::getModules($this->position))) {
//            $return_html .= ' <jdoc:include type="modules" name="' . $this->position . '"  style="xhtml" />';
//        }
//        if ($this->params->get('brand') == 0) {
//            $return_html .= '<div class="clearfix"></div><div class="biged"><a href="' . $this->show_default_param('linkcopy', "https://marlev.it/") . '" target="_blank">' . $this->show_default_param('copy', "Designed by Marlev.it") . '</span></a></div>';
//        }
//        $return_html .= "";
//        $return_html .= $div->closediv;
//        return $return_html;
//    }


//    protected function show_default($div) {
//        $return_html = "";
//        if (count(ModuleHelper::getModules($this->position))) {
//            $return_html .= $div->opendiv;
//            $return_html .= ' <jdoc:include type="modules" name="' . $this->position . '"  style="xhtml" />';
//            $return_html .= $div->closediv;
//        }
//        return $return_html;
//    }
