<?php

/**
 *
 * @extension       Marlev - Template Manager
 * @author          Lev Milicenco<support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2017 marlev.it All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
defined('_JEXEC') or die;

//function for tab edit > options
class ml_device_options {

    public $move;
    public $posname;
    public $posdata;
    public $options;
    public $device;
    public $parentid;
    public $selected;
    public $layout;
    public $template;

    function __construct($posdata, $posname, $parentid, $selected, $layout, $template) {
        $this->move = array("offset", "push", "pull");
        $this->posdata = $posdata;
        $this->posname = $posname;

        $this->options = $this->generate_options_numeric();
        $this->parentid = $parentid;
        $this->selected = $selected;
        $this->layout = $layout;
        $this->template = $template;
    }

//main function
    function devices($value) {
        $this->device = $value;
        $return = "";
        if ($this->posdata->colchange == true) {
            $return .= $this->change_cols();
        } else {
            $return .= '<input type="hidden" name="layout[' . $this->device = $value . '][' . $this->posname . ']" value="12" >';
        }
        if ($this->posdata->invisible == true) {
            $return .= $this->change_invisible();
        } else {
            $return .= '<input type="hidden" name="layout[hide' . $this->device . '][' . $this->posname . ']" value="" >';
        }
        foreach ($this->move as $k => $v) {
            //  if ($this->posdata->$v == true) {
            $return .= $this->move_push_pull_offset($v);
//            } else {
//                $return .= '<input type="hidden" name="layout[' . $v . $this->device . '][' . $this->posname . ']" value="" >';
//            }
        }
        $return .= $this->add_clearfix_after_position();
        return $return;
    }

    protected function generate_options_numeric() {
        $options = array();
        for ($a = 1; $a <= 12; $a++) {
            $options[] = JHTML::_('select.option', $a, $a);
        }
        return $options;
    }

    protected function define_selected($key, $selected = '') {
        if (isset($this->layout[$key][$this->posname])) {
            $selected = $this->layout[$key][$this->posname];
        }
        return $selected;
    }

    protected function return_html($content, $lang, $controlsidentifer, $tooltip = null, $image = null) {
        $tooltip_top = array("addclearfix","pull");
        $tooltip_position = "right";
        if (in_array($controlsidentifer, $tooltip_top)) {
            $tooltip_position = "top";
        }
        if ($image != null) {
            $image = '<br/><img src="' . JPATH_ROOT . '/templates/' . $this->template . '/images/systems/' . $image . '" />';
        }
        $return = '';
        $dataident = ($controlsidentifer == false) ? "" : 'data-identifier="' . $controlsidentifer . '"';
        $return .= '<div class="control-group">';
        $return .= '<div class="control-label"><label class="hasPopover" data-content="' . $tooltip . $image . '" data-original-title="' . $lang . '" data-placement="'.$tooltip_position.'">' . $lang . '</label></div>';
        $return .= '<div class="controls ' . $controlsidentifer . '" ' . $dataident . ' >' . $content . '</div>';
        $return .= '</div>';
        return $return;
    }

    protected function change_cols() {
        $value = $this->device;
        $return_op = JHTML::_('select.genericlist', $this->options, 'layout[' . $value . '][' . $this->posname . ']', 'class="colchange" data-type="' . $value
                        . '" data-position="' . $this->posname . '" data-id="' . $this->parentid . '"', 'value', 'text', $this->selected->$value);

        return $this->return_html($return_op, jText::_("COM_TMARLEV_LARGEZZA_COL") . ' ' . ucfirst($value), "colchange", jText::_("COM_TMARLEV_LARGEZZA_COL_DESC"));
    }

    protected function add_clearfix_after_position() {
        $selected = $this->define_selected('addclear' . $this->device);
        if (!empty($selected)) {
            $selected = 'checked="checked"';
        }
        $return_op = '<div class="checkbox checkbox-primary checkbox-intab"><input class="addclear" id="checkbox-' . $this->posname . '" data-position="' . $this->posname . '" data-device="' . $this->device . '" type="checkbox" ' . $selected . ' name="layout[addclear' . $this->device . '][' . $this->posname . ']" value="1" />'
                . '<label for="checkbox-' . $this->posname . '"></label></div>';


        return $this->return_html($return_op, jText::_("COM_TMARLEV_ADD_CLEARFIX_AFTER_POSITION"), "addclearfix", jText::_("COM_TMARLEV_ADD_CLEARFIX_AFTER_POSITION_DESC"));
    }

    protected function change_invisible() {
        switch ($this->device) {
            case"pc": $class = 'hidden-lg hidden-md';
                break;
            case"tablet": $class = 'hidden-sm';
                break;
            case"mobile": $class = 'hidden-xs';
                break;
        }
        $selected = $this->define_selected('hide' . $this->device, 'ml-' . $this->device . '-show');
        $options = array();
        $options[] = JHTML::_('select.option', 'ml-' . $this->device . '-show', JText::_("JSHOW"));
        $options[] = JHTML::_('select.option', $class, JText::_("JHIDE"));
        $return_op = JHTML::_('select.genericlist', $options, 'layout[hide' . $this->device . '][' . $this->posname . ']', '', 'value', 'text', $selected);
        return $this->return_html($return_op, jText::_("COM_TMARLEV_HIDE_COL") . ' ' . ucfirst($this->device), 'hide' . $this->device, jText::_("COM_TMARLEV_HIDE_COL_DESC"));
    }

    protected function move_push_pull_offset($movemode) {
        $define = $movemode . $this->device;
        $selected = $this->define_selected($define);
        $options = $this->prepare_options_move($movemode);
        $return_op = JHTML::_('select.genericlist', $options, 'layout[' . $define . '][' . $this->posname . ']', 'class="colmove" data-type="'
                        . $this->device . '" data-position="' . $this->posname . '" data-move="' . $movemode . '" data-id="' . $this->parentid . '"', 'value', 'text', $selected);
        return $this->return_html($return_op, ucfirst($movemode), $movemode, jText::_("COM_TMARLEV_MOVE_" . $movemode));
    }

    protected function prepare_options_move($movemode) {
        $options = array();
        for ($a = 0; $a <= 12; $a++) {
            switch ($this->device) {
                case "pc": $classes = 'col-lg-' . $movemode . '-' . $a . ' col-md-' . $movemode . '-' . $a;
                    break;
                case "tablet": $classes = 'col-sm-' . $movemode . '-' . $a;
                    break;
                case "mobile": $classes = 'col-xs-' . $movemode . '-' . $a;
                    break;
            }

            $options[] = JHTML::_('select.option', $classes, ucfirst($movemode) . '-' . $a);
        }
        return $options;
    }

}


