<?php

/**
 *
 * @extension       MarlevUpdate - Marlev Extensions Automatic Update
 * @author          Lev Milicenco<support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2022 marlev.it All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
defined('_JEXEC') or die;

use Joomla\CMS\Version;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;
use Joomla\CMS\Uri\Uri;

class plgInstallerMarlevupdate extends CMSPlugin
{

    public function onInstallerBeforePackageDownload(&$url, &$headers)
    {


        $uri = Uri::getInstance($url);
        $host = $uri->getHost();
        if (!in_array($host, $this->update_servers())) {
            return true;
        }

        $extension = trim($uri->getVar("extension"));
        $plg = trim($uri->getVar("plugintype"));
        $explode_ext = explode("_", $extension);


        $param = new Registry();
        if ($explode_ext[0] == "com") {
            $com_params = ComponentHelper::getComponent($extension)->getParams();
            $gets = (array)$com_params->get("params");
            $get_params = $param->loadArray($gets);
        } else if ($explode_ext[0] == "tpl") {
            $get_templatekey = $this->get_marlevtemplate($explode_ext[1]);
            $get_params = $param->loadString($get_templatekey);
        } else if ($explode_ext[0] == "plg" && !empty($plg)) {
            $plugin = PluginHelper::getPlugin($plg, $explode_ext[1]);
            $get_params = $param->loadString($plugin->params);
        } else {
            return true;
        }

        $update_key = $get_params->get('product_key');
        $private_key = $get_params->get('private_key');


        if (empty($update_key) || empty($private_key)) {
            $app = Factory::getApplication();
            $app->enqueueMessage(Text::_('<strong>Update Key & Private Key are required for automatic update of Marlev Extensions</strong>'), 'notice');
            return false;
        }

        $uri->setVar('product_key', $update_key);
        $uri->setVar('private_key', $private_key);
        $url = $uri->toString();
        return true;
    }

    private function getjversion()
    {
        $v = new Version();
        $getter = explode(".", $v->getShortVersion());
        return $getter[0];
    }

    private function get_marlevtemplate($template)
    {
        $return = '';
        if (ComponentHelper::getComponent('com_tmarlev', true)->enabled && $this->getjversion() == 4) {
            $db = Factory::getContainer()->get('DatabaseDriver');
            $query = $db->getQuery(true);
            $query->select('params');
            $query->from('#__tmarlev_update');
            $query->where('template=' . $db->Quote($template));
            $db->setQuery($query);
            $return = $db->loadResult();
        }
        if (ComponentHelper::getComponent('com_tmarlevv2', true)->enabled && empty($return)) {
            $db = Factory::getContainer()->get('DatabaseDriver');
            $query = $db->getQuery(true);
            $query->select('params');
            $query->from('#__tmarlevv2_update');
            $query->where('template=' . $db->Quote($template));
            $db->setQuery($query);
            $return = $db->loadResult();
        }
        return $return;
    }

    protected function update_servers()
    {
        return array("marlev.it", "itroom.it");
    }

}
