<?php
/**
 * @extension       Marlev Template
 * @author          Lev Milicenco<support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2013 marlev.it All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
defined('_JEXEC') or die;
$getlang = JFactory::getLanguage();
$registry = new JRegistry;
$editorparams = array(
);
$editor = JFactory::getEditor("tinymce");
?>

<div class="tm-offline tm-config"  >


    <h3><?php echo JText::_("TPL_MARLEV_OFFLINE"); ?></h3>
    <div class="slide-config-title"  >

        <?php
        $offlinelink = str_replace("administrator/", "", JURI::base()) . "index.php?loadoffline=1";
        echo JText::_("COM_TMARLEV_PAGEOFFLINE_ALERT_LABEL") . ' <br/><a href="' . $offlinelink .'" target="new" >'.$offlinelink.'</a>';
        ?>
    </div>

    <div class="control-group">
        <div class="control-label">
            <?php echo $this->form->getLabel('cookie_deflang'); ?>
        </div>
        <div class="controls">

            <select id="params_offline_deflang"  name="params[offlinepage_deflang]" >
                <?php
                foreach ($this->lang_params->langs as $lang):
                    $lang->lang_code = $lang->lang_code;
                    ?>
                    <option <?php if ((isset($this->lang_params->params["offlinepage_deflang"]) && $this->lang_params->params["offlinepage_deflang"] == $lang->lang_code)) echo 'selected="selected"'; ?> value="<?php echo $lang->lang_code; ?>"><?php echo $lang->title; ?></option>
                    <?php
                endforeach;
                ?>


            </select>

        </div>


    </div>
    <div class="control-group">
        <div class="control-label">
            <?php echo $this->form->getLabel('offline_counter'); ?>
        </div>
        <div class="controls">
            <?php echo $this->form->getInput('offline_counter'); ?>
        </div>
    </div>
    <div class="control-group offline_whensiteonline">
        <div class="control-label">
            <?php echo $this->form->getLabel('offline_online'); ?>
        </div>
        <div class="controls">

            <?php echo $this->form->getInput('offline_online'); ?>

            <div class="clearfix"></div>


            <span>  <?php echo JText::_("COM_TMARLEV_CURRENT_TIME") ?>: </span> <span  class="curent-server-time"><?php echo JFactory::getDate()->format('Y-m-d H:i:s'); ?></span>
            <span  ><a href="#" class="btn btn-primary udpate-date">
                    <span class="icon-refresh" aria-hidden="true"></span><?php echo JText::_("COM_TMARLEV_UPDATE_NOW") ?></a>
            </span>
        </div>
        <div class="clearfix"></div>

    </div>
    <div class="clearfix"></div>
    <div id="offline-modules-config" class="tabs-config">
        <?php echo JHtml::_('bootstrap.startTabSet', 'offlinepagetab', array('active' => 'offlinepage-' . $getlang->getTag())); ?>

        <?php
        foreach ($this->lang_params->langs as $key):
            $key->lang_code = $key->lang_code;
            echo JHtml::_('bootstrap.addTab', 'offlinepagetab', 'offlinepage-' . $key->lang_code, $key->title);


            $text_offlinepage = "";


            if (isset($this->lang_params->params['offlinetext_' . $key->lang_code])) {
                $text_offlinepage = $this->lang_params->params['offlinetext_' . $key->lang_code];
            }
            ?>


            <div class="slide-config-title"  >
                <strong><?php echo JText::_("COM_TMARLEV_CONFIGURAZIONE_OFFLINEPAGE_PER") . " " . $key->title; ?></strong>

            </div>




            <div class="clearfix"></div>
            <div class="slide-config-title">

                <?php echo JText::_("TPL_MARLEV_WHEN_SHOW_OFFLINE_MESSAGE") ?>

            </div>
            <div class="modules-config" data-lang="<?php echo str_replace("-", "_", $key->lang_code); ?>">
                <?php
                echo $editor->display('params[offlinetext_' . $key->lang_code . ']', $text_offlinepage, '400', '400', '20', '20', true, null, null, null, $editorparams);
                ?>
            </div>







            <?php echo JHtml::_('bootstrap.endTab'); ?>
        <?php endforeach; ?>
        <?php echo JHtml::_('bootstrap.endTabSet'); ?>

    </div>
    <div class="clearfix"></div>
</div>

