<?php
/**
 * @extension       Marlev Template
 * @author          Lev Milicenco<support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2013 marlev.it All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
defined('_JEXEC') or die;
$getlang = JFactory::getLanguage();
$registry = new JRegistry;
$editorparams = array(
    'smilies' => '0',
    'style' => '1',
    'layer' => '0',
    'table' => '0',
    'mode' => '1',
    'clear_entities' => '0'
);
$editor = JFactory::getEditor("tinymce");
?>

<div class="tm-errorpage tm-config"  >


    <h3><?php echo JText::_("TPL_MARLEV_ERRORPAGE"); ?></h3>
    <div class="slide-config-title"  >

        <?php
        $getlink = str_replace("administrator/", "", JURI::base()) . "index.php?option=com_testerrorpage";


        echo str_replace("{link_error_page}", '<a href="' . $getlink . '" target="new">' . $getlink . '</a>', JText::_("COM_TMARLEV_PAGEERROR_ALERT_LABEL"));
        ?>
    </div>

    <div class="control-group">
        <div class="control-label">
            <?php echo $this->form->getLabel('cookie_deflang'); ?>
        </div>
        <div class="controls">

            <select id="params_cookie_deflang"  name="params[errorpage_deflang]" >
                <?php
     
                foreach ($this->lang_params->langs as $lang):
                    $lang->lang_code = $lang->lang_code;
                    ?>
                    <option <?php if ((isset($this->lang_params->params["errorpage_deflang"]) && $this->lang_params->params["errorpage_deflang"] == $lang->lang_code)) echo 'selected="selected"'; ?> value="<?php echo $lang->lang_code; ?>"><?php echo $lang->title; ?></option>
                    <?php
                endforeach;
                ?>


            </select>

        </div>


    </div>

    <div id="error-modules-config" class="tabs-config">
        <?php echo JHtml::_('bootstrap.startTabSet', 'errorpagetab', array('active' => 'errorpage-' . $getlang->getTag())); ?>

        <?php
        foreach ($this->lang_params->langs as $key):
            $key->lang_code = $key->lang_code;
            echo JHtml::_('bootstrap.addTab', 'errorpagetab', 'errorpage-' . $key->lang_code, $key->title);


            $text_errorpage = "";


            if (isset($this->lang_params->params['errortext_' . $key->lang_code])) {
                $text_errorpage = $this->lang_params->params['errortext_' . $key->lang_code];
            }
            ?>


            <div class="slide-config-title"  >
                <strong><?php echo JText::_("COM_TMARLEV_CONFIGURAZIONE_ERRORPAGE_PER") . " " . $key->title; ?></strong>

            </div>



            <div class="control-group">
                <div class="control-label">
                    <label class="hasPopover" data-content="<?php echo JText::_("TPL_MARLEV_SELECT_MODULES_IN_ERROR_PAGE_DESK") ?>">
                        <?php echo JText::_("TPL_MARLEV_SELECT_MODULES_IN_ERROR_PAGE") ?>
                    </label>
                </div>
                <div class="controls">
                    <select  multiple="" style="width:300px;" name="params[errormodules_<?php echo $key->lang_code ?>]" >

                        <?php
                        $savedmodules = array();
                        if (isset($this->lang_params->params['errormodules_' . $key->lang_code])) {
                            $registry->loadString($this->lang_params->params['errormodules_' . $key->lang_code]);
                            $savedmodules = $registry->toArray();
                        }

                        foreach ($this->modules as $module):
                            if ($module->language == "*" || $module->language == $key->lang_code):
                                $mod_value = $module->id . '[|]' . $module->position;
                                $selecte = '';
                           
                                    if (in_array($mod_value, $savedmodules)) {
                                        $selecte = 'selected="selected"';
                                    }
                                
                                ?>
                                <option <?php echo $selecte; ?> value="<?php echo $mod_value ?>"><?php echo $module->title . "[" . $module->position . "]"; ?></option>

                                <?php
                            endif;
                        endforeach;
                        ?>



                    </select>
                    <div class="clearfix"></div>
                </div>
            </div>
            <div class="clearfix"></div>
            <div class="slide-config-title" >

                <?php echo JText::_("TPL_MARLEV_SELECT_CONTENT_IN_ERROR_PAGE") ?>

            </div>
            <div class="modules-config" data-lang="<?php echo str_replace("-", "_", $key->lang_code); ?>">
                <?php
                echo $editor->display('params[errortext_' . $key->lang_code . ']', $text_errorpage, '400', '400', '20', '20', true, null, null, null, $editorparams);
                ?>
            </div>







            <?php echo JHtml::_('bootstrap.endTab'); ?>
        <?php endforeach; ?>
        <?php echo JHtml::_('bootstrap.endTabSet'); ?>

    </div>
    <div class="clearfix"></div>
</div>

