<?php
namespace Marlev\Component\Tmarlevv2\Administrator\Helper;
/**
 * @extension       Marlev TM V2
 * @author          Lev Milicenco <support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2017 marlev.it All Rights Reserved

 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

use Joomla\CMS\Factory;
use Joomla\Registry\Registry;
use Joomla\CMS\Cache\Cache;
//for_use
defined('_JEXEC') or die;

class ml_plugin_helper
{

    static public function get_layout($tid, $template, $params)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('a.layout,b.params');
        $query->from('#__tmarlevv2_layout as a')
            ->join('LEFT', $db->quoteName('#__tmarlevv2_static', 'b') . ' ON (' . $db->quoteName('b.template') . ' = ' . $db->Quote($template) . ')');
        $query->where('a.tid=' . $db->Quote($tid));
        $db->setQuery($query);
        $layout = $db->loadObjectList();

        $return = new \stdClass();
        $return->layout = false;
        $return->params = array();
        if (!empty($layout[0])) {
            $return->layout = array();
            $registry = new Registry;
            $registry->loadString($layout[0]->layout);
            $return->layout['tlayout'] = $registry->toArray();
            $return->layout['tid'] = $tid;

            $registry = new Registry;
            $registry->loadString($layout[0]->params);
            $return->params = $registry->toArray();
        }
        $return->params["socials"] = self::socials_helper($params);

        if (is_array($return->layout)) {
            return array_merge($return->layout, $return->params);
        }
    }

    static public function prepare_cache($cache_id, $cachegroup)
    {
        $cache = Cache::getInstance('output', array('caching' => true));
        $getcache = $cache->get($cache_id, $cachegroup);
        return $getcache;
    }

    static public function set_cache($tocache, $cache_id, $cachegroup)
    {
        $options = array('lifetime' => 10080, 'caching' => true);
        $cache = Cache::getInstance('callback', $options);
        $cache->setCaching(true);
        $tocache = json_encode($tocache);
        $cache->store($tocache, $cache_id, $cachegroup);
    }


    static public function socials_helper($params)
    {
        $social = array();
        $btns = array(
            "socialfacebook" => ["facebooklink", "https://facebook.com"],
            "socialinstagram" => ["instagramlink", "https://instagram.com"],
            "socialgoogle" => ["googlelink", "https://plus.google.com/"],
            "socialtwitter" => ["twitterlink", "https://twitter.com/"],
            "socialyoutube" => ["youtubelink", "https://www.youtube.com/"],
            "sociallinkedin" => ["inlink", "https://linkedin.com"],
            "socialok" => ["oklink", "https://ok.ru"],
            "socialvk" => ["vklink", "https://vk.com"]
        );
        $social["font"] = array(

            "socialfacebook" => '<i class="fab fa-facebook ml-facebook" aria-hidden="true"></i>',
            "socialinstagram" => '<i class="fab fa-instagram ml-instagram" aria-hidden="true"></i>',
            "socialgoogle" => '<i class="fab fa-google-plus ml-googleplus" aria-hidden="true"></i>',
            "socialtwitter" => '<i class="fab fa-x-twitter ml-twitter" aria-hidden="true"></i>',
            "socialyoutube" => '<i class="fab fa-youtube ml-youtube" aria-hidden="true"></i>',
            "sociallinkedin" => '<i class="fab fa-linkedin ml-linkedin" aria-hidden="true"></i>',
            "socialok" => '<i class="fab fa-odnoklassniki ml-ok" aria-hidden="true"></i>',
            "socialvk" => '<i class="fab fa-vk ml-vk" aria-hidden="true"></i>'
        );

        foreach ($btns as $key => $value) {
            if ($params->params->get($key) == true) {
                $link = $params->params->get($value[0], false);
                if ($link == false) {
                    $link = $value[1];
                }
                $social["btns"][$key] = $link;
            } else {
                unset($social["font"][$key]);
            }
        }
        if (empty($social["font"])) {
            return false;
        }
        return $social;
    }

}

?>
