<?php
namespace Marlev\Component\Tmarlevv2\Administrator\Helper;
/**
 *
 * @extension       Marlev - Template Manager
 * @author          Lev Milicenco<support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2017 marlev.it All Rights Reserved

 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

//use Marlev\Component\Tmarlevv2\Administrator\Helper\marlev_fonts;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
//for_use
defined('_JEXEC') or die;

//function for tab edit > options
class ml_tab_options
{

    public $posname;
    public $template;
    public $layout;
    public $device;
    public $fonts = array();

    function __construct($posname, $layout, $template)
    {
        $this->template = $template;
        $this->layout = $layout;
        $this->prepare_fonts();
    }

    function prepare_fonts()
    {
        $fonts = new marlev_fonts();
        $this->fonts[] = HtmlHelper::_('select.option', "", "Default Parent");
        foreach ($fonts->avvaiable_fonts() as $key => $value) {
            $this->fonts[] = HtmlHelper::_('select.option', $key, $key);
        }
    }

    function tab_options($posdata, $posname, $value, $tab)
    {
        $this->device = $value;
        $return = "";
        $this->posname = $posname;

        if ($tab == "sfondo" || $tab == "effect") {
            if (isset($posdata->params["effect"])) {
                $return .= $this->tab_option_effect();
                $return .= $this->tab_option_effect_speed();
                $return .= $this->tab_option_effect_delay();
            }
            if (isset($posdata->params["backgroundall"])) {

                $return .= $this->choise_background_type();
                $return .= $this->background_color();
                $return .= $this->background_image();
                $return .= $this->background_repeat();
                $return .= $this->background_attachment();
                $return .= $this->background_position();
            }
        } elseif ($tab == "stile") {
            if (!in_array($posname, array("header_section", "content_section", "footer_section"))) {
                $return .= '<div class="ml-tab-separator">Border</div>';
                 $return .= $this->stile_bordertype();
                $return .= $this->stile_borderwidth();
                $return .= $this->stile_borderradius();
                $return .= $this->stile_borderstyle();
                $return .= $this->stile_bordercolor();
            }
            $return .= '<div class="ml-tab-separator">Padding<div class="small" style="text-align:center">' . Text::_("COM_TMARLEV_PADDING_WHAT_IS") . '</div></div>';
            $return .= $this->stile_paddings();
            $return .= '<div class="ml-tab-separator">Margin<div class="small" style="text-align:center">' . Text::_("COM_TMARLEV_MARGIN_WHAT_IS") . '</div></div>';
            $return .= $this->stile_margins();
        } elseif ($tab == "font") {
            $return .= '<div class="ml-tab-separator">' . Text::_("COM_TMARLEV_FONT_STYLE_COLOR") . '</div>';
            $return .= $this->font_font();
            $return .= $this->font_align();
            $return .= $this->font_fontcolor();
            $return .= $this->font_weight();
            $return .= $this->font_linkcolor();
            $return .= $this->font_linkunderline();
            $return .= $this->font_linkcolorhover();
            $return .= $this->font_linkunderlinehover();
            $return .= $this->font_honecolor();
            $return .= $this->font_htwocolor();
            $return .= $this->font_htrecolor();
            $return .= $this->font_h4color();
            $return .= $this->font_h5color();
            $return .= $this->font_h6color();
            $return .= '<div class="ml-tab-separator">' . Text::_("COM_TMARLEV_FONT_DIMENSIONS") . ' & Utils</div>';
            $return .= $this->font_fontsize();
            $return .= $this->font_lineheight();
            $return .= $this->font_texttransform('text');
            $return .= $this->font_honesize();
            $return .= $this->font_texttransform('h1');
            $return .= $this->font_htwosize();
            $return .= $this->font_texttransform('h2');
            $return .= $this->font_htresize();
            $return .= $this->font_texttransform('h3');
            $return .= $this->font_h4size();
            $return .= $this->font_texttransform('h5');
            $return .= $this->font_h5size();
            $return .= $this->font_texttransform('h5');
            $return .= $this->font_h6size();
            $return .= $this->font_texttransform('h6');
        } elseif ($tab == "shadow") {
            $return .= '<div class="ml-tab-separator">' . Text::_("Box Shadow") . '<div class="small" style="text-align:center">' . Text::_("COM_TMARLEV_BOX_SHADOW_WHAT_IS") . '</div></div>';
            $return .= $this->shadow_inset();
            $return .= $this->shadow_h();
            $return .= $this->shadow_v();
            $return .= $this->shadow_blur();
            $return .= $this->shadow_spread();
            $return .= $this->shadow_color();
            $return .= '<div class="ml-tab-separator">' . Text::_("Box Shadow Hover") . '<div class="small" style="text-align:center">' . Text::_("COM_TMARLEV_BOX_SHADOW_HOVER_WHAT_IS") . '</div></div>';
            $return .= $this->shadow_inset_hover();
            $return .= $this->shadow_h_hover();
            $return .= $this->shadow_v_hover();
            $return .= $this->shadow_blur_hover();
            $return .= $this->shadow_spread_hover();
            $return .= $this->shadow_color_hover();
        }
        elseif ($tab == "child") {
            $return .= '<div class="ml-tab-separator">' . Text::_("Child") . '<div class="small" style="text-align:center">' . Text::_("COM_TMARLEV_BOX_CHILD_WHAT_IS") . '</div></div>';
            $return .= $this->child_disable_padding();
            $return .= $this->child_align_items();
        }

        return $return;
    }
    //todo
    protected function child_align_items()
    {
        $effects = array(
            "" => Text::_("COM_TMARLEV_NONE") ."(Default)",
            "center" => "Center",
            "top" => "Top",
            "bottom" => "Bottom"
        );
        $selected = '';
        if (isset($this->layout['css'][$this->device][$this->posname]['child_align_items'])) {
            $selected = $this->layout['css'][$this->device][$this->posname]['child_align_items'];
        }
        $options = array();
        foreach ($effects as $key => $value) {
            $options[] = HtmlHelper::_('select.option', $key, $value);
        }
        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][child_align_items]', 'class="child_align" data-position="' . str_replace("_subsection","",$this->posname) . '" data-type="'.$this->device.'"', 'value', 'text', $selected);
        return $this->return_html($return_op, "TPL_MARLEV_CHILD_VERTICAL_ALIGN", 'child_align_items', '', "TPL_MARLEV_CHILD_VERTICAL_ALIGN_DESC");
    }

    protected function child_disable_padding()
    {
        $effects = array(
            "" => Text::_("JYES") ."(Default)",
            "disable" => Text::_("JNO")
        );
        $selected = '';
        if (isset($this->layout['css'][$this->device][$this->posname]['child_disable_padding'])) {
            $selected = $this->layout['css'][$this->device][$this->posname]['child_disable_padding'];
        }
        $options = array();
        foreach ($effects as $key => $value) {
            $options[] = HtmlHelper::_('select.option', $key, $value);
        }
        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][child_disable_padding]', 'class="child_padding" data-position="' . str_replace("_subsection","",$this->posname) . '" data-type="'.$this->device.'"', 'value', 'text', $selected);
        return $this->return_html($return_op, "TPL_MARLEV_CHILD_PADDING_DISABLE", 'child_disable_padding', '', "TPL_MARLEV_CHILD_PADDING_DISABLE_DESC");
    }
    protected function shadow_inset()
    {
        $effects = array(
            "" => Text::_("COM_TMARLEV_SHADOW_ESTERNO"),
            "inset" => Text::_("COM_TMARLEV_SHADOW_INTERNO")
        );
        $selected = '';
        if (isset($this->layout['css'][$this->device][$this->posname]['shadowinset'])) {
            $selected = $this->layout['css'][$this->device][$this->posname]['shadowinset'];
        }
        $options = array();
        foreach ($effects as $key => $value) {
            $options[] = HtmlHelper::_('select.option', $key, $value);
        }
        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][shadowinset]', '', 'value', 'text', $selected);
        return $this->return_html($return_op, "TPL_MARLEV_FONT_SHADOW_INSET", 'shadowinset', '', "TPL_MARLEV_FONT_SHADOW_INSET_DESC");
    }

    protected function shadow_inset_hover()
    {
        $effects = array(
            "" => Text::_("COM_TMARLEV_SHADOW_ESTERNO"),
            "inset" => Text::_("COM_TMARLEV_SHADOW_INTERNO")
        );
        $selected = '';
        if (isset($this->layout['css'][$this->device][$this->posname]['shadowinsethover'])) {
            $selected = $this->layout['css'][$this->device][$this->posname]['shadowinsethover'];
        }
        $options = array();
        foreach ($effects as $key => $value) {
            $options[] = HtmlHelper::_('select.option', $key, $value);
        }
        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][shadowinsethover]', '', 'value', 'text', $selected);
        return $this->return_html($return_op, "TPL_MARLEV_FONT_SHADOW_INSET", 'shadowinsethover', '', "TPL_MARLEV_FONT_SHADOW_INSET_DESC");
    }

    protected function shadow_h()
    {
        return $this->sizer_show('hshadow', "TPL_MARLEV_FONT_SHADOW_H", "hshadow");
    }

    protected function shadow_h_hover()
    {
        return $this->sizer_show('hshadowhover', "TPL_MARLEV_FONT_SHADOW_H", "hshadowhover");
    }

    protected function shadow_v()
    {
        return $this->sizer_show('vshadow', "TPL_MARLEV_FONT_SHADOW_V", "vshadow");
    }

    protected function shadow_v_hover()
    {
        return $this->sizer_show('vshadowhover', "TPL_MARLEV_FONT_SHADOW_V", "vshadowhover");
    }

    protected function shadow_blur()
    {
        return $this->sizer_show('shadowblur', "TPL_MARLEV_FONT_SHADOW_BLUR", "shadowblur");
    }

    protected function shadow_blur_hover()
    {
        return $this->sizer_show('shadowblurhover', "TPL_MARLEV_FONT_SHADOW_BLUR", "shadowblurhover");
    }

    protected function shadow_spread()
    {
        return $this->sizer_show('shadowspread', "TPL_MARLEV_FONT_SHADOW_SPREAD", "shadowspread");
    }

    protected function shadow_spread_hover()
    {
        return $this->sizer_show('shadowspreadhover', "TPL_MARLEV_FONT_SHADOW_SPREAD", "shadowspreadhover");
    }

    protected function shadow_color()
    {
        $selected = $this->define_selected('shadowcolor');
        $return_op = '<input  class="minicolors minicolors-input rgb-color"  type="text" size="10" value="' . $selected . '" name="layout[css][' . $this->device . '][' . $this->posname . '][shadowcolor]" >';
        return $this->return_html($return_op, "TPL_MARLEV_FONT_SHADOW_COLOR", 'shadowcolor', 'colors-box', "TPL_MARLEV_FONT_SHADOW_COLOR_DESC");
    }

    protected function shadow_color_hover()
    {
        $selected = $this->define_selected('shadowcolorhover');
        $return_op = '<input  class="minicolors minicolors-input rgb-color"  type="text" size="10" value="' . $selected . '" name="layout[css][' . $this->device . '][' . $this->posname . '][shadowcolorhover]" >';
        return $this->return_html($return_op, "TPL_MARLEV_FONT_SHADOW_COLOR", 'shadowcolorhover', 'colors-box', "TPL_MARLEV_FONT_SHADOW_COLOR_DESC");
    }
    protected function font_align()
    {
        $effects = array(
            "" => Text::_("Default"),
            "right" => "right",
            "center" => "center",
            "left" => 'left'
        );
        $selected = ''; //$this->define_selected('effect');
        if (isset($this->layout['css'][$this->device][$this->posname]['font_align'])) {
            $selected = $this->layout['css'][$this->device][$this->posname]['font_align'];
        }
        $options = array();
        foreach ($effects as $key => $value) {
            $options[] = HtmlHelper::_('select.option', $key, $value);
        }
        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][font_align]', '', 'value', 'text', $selected);
        return $this->return_html($return_op, "TPL_MARLEV_FONT_ALIGN", 'font_align', '', 'TPL_MARLEV_FONT_ALIGN_DESC');
    }
    protected function font_weight()
    {
        $effects = array(
            "" => Text::_("Default"),
            "normal" => "Normal",
            "bold" => 'Bold',
            "lighter" => "Lighter",
            "bolder" => 'Bolder',
            "100" => '100',
            "900" => '900'
        );
        $selected = ''; //$this->define_selected('effect');
        if (isset($this->layout['css'][$this->device][$this->posname]['font_weight'])) {
            $selected = $this->layout['css'][$this->device][$this->posname]['font_weight'];
        }
        $options = array();
        foreach ($effects as $key => $value) {
            $options[] = HtmlHelper::_('select.option', $key, $value);
        }
        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][font_weight]', '', 'value', 'text', $selected);
        return $this->return_html($return_op, "TPL_MARLEV_FONT_WEIGHT", 'font_weight', '', 'TPL_MARLEV_FONT_WEIGHT_DESC');
    }

    protected function font_font()
    {
        $selected = '';
        if (isset($this->layout['css'][$this->device][$this->posname]['font'])) {
            $selected = $this->layout['css'][$this->device][$this->posname]['font'];
        }

        $return_op = HtmlHelper::_('select.genericlist', $this->fonts, 'layout[css][' . $this->device . '][' . $this->posname . '][font]', '', 'value', 'text', $selected);
        return $this->return_html($return_op, "TPL_MARLEV_FONT_LABEL", 'font', '', "TPL_MARLEV_FONT_DESC");
    }

    protected function font_fontcolor()
    {
        $selected = $this->define_selected('fontcolor');
        $return_op = '<input  class="minicolors minicolors-input"  type="text" size="10" value="' . $selected . '" name="layout[css][' . $this->device . '][' . $this->posname . '][fontcolor]" >';
        return $this->return_html($return_op, "TPL_MARLEV_FONT_COLOR_LABEL", 'fontcolor', 'colors-box', 'TPL_MARLEV_FONT_COLOR_DESC');
    }

    protected function font_linkcolor()
    {
        $selected = $this->define_selected('linkcolor');
        $return_op = '<input  class="minicolors minicolors-input"  type="text" size="10" value="' . $selected . '" name="layout[css][' . $this->device . '][' . $this->posname . '][linkcolor]" >';
        return $this->return_html($return_op, "TPL_MARLEV_FONT_COLOR_LINK_LABEL", 'linkcolor', 'colors-box', 'TPL_MARLEV_FONT_COLOR_LINK_DESC');
    }

    protected function font_linkunderline()
    {
        $effects = array(
            "" => Text::_("COM_TMARLEV_NONE"),
            "none" => Text::_("JNO"),
            "underline" => Text::_("JYES")
        );
        $selected = ''; //$this->define_selected('effect');
        if (isset($this->layout['css'][$this->device][$this->posname]['linkunderline'])) {
            $selected = $this->layout['css'][$this->device][$this->posname]['linkunderline'];
        }
        $options = array();
        foreach ($effects as $key => $value) {
            $options[] = HtmlHelper::_('select.option', $key, $value);
        }
        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][linkunderline]', '', 'value', 'text', $selected);
        return $this->return_html($return_op, "TPL_MARLEV_FONT_UNDERLINE", 'linkunderline', '', 'TPL_MARLEV_FONT_UNDERLINE_DESC');
    }

    protected function font_linkcolorhover()
    {
        $selected = $this->define_selected('linkcolorhover');
        $return_op = '<input  class="minicolors minicolors-input"  type="text" size="10" value="' . $selected . '" name="layout[css][' . $this->device . '][' . $this->posname . '][linkcolorhover]" >';
        return $this->return_html($return_op, "TPL_MARLEV_FONT_COLOR_HOVER", 'linkcolorhover', 'colors-box', 'TPL_MARLEV_FONT_COLOR_HOVER_DESC');
    }
    protected function font_texttransform($name)
    {
        $effects = array(
            "" => Text::_("COM_TMARLEV_NONE"),
            "capitalize" => 'capitalize',
            "uppercase" => 'uppercase',
            "lowercase" => 'lowercase',
            "none" => 'none',
            "full-width" => 'full-width',
            "full-size-kana" => 'full-size-kana',
        );
        $selected = ''; //$this->define_selected('effect');
        if (isset($this->layout['css'][$this->device][$this->posname]['text_transform_'.$name])) {
            $selected = $this->layout['css'][$this->device][$this->posname]['text_transform_'.$name];
        }
        $options = array();
        foreach ($effects as $key => $value) {
            $options[] = HtmlHelper::_('select.option', $key, $value);
        }
        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][text_transform_'.$name.']', '', 'value', 'text', $selected);
        return $this->return_html($return_op, "TPL_MARLEV_TEXT_TRANSFORM_".strtoupper($name), 'text_transform_'.$name, '', 'TPL_MARLEV_TEXT_TRANSFORM_DESC');
    }

    protected function font_linkunderlinehover()
    {
        $effects = array(
            "" => Text::_("COM_TMARLEV_NONE"),
            "none" => Text::_("JNO"),
            "underline" => Text::_("JYES")
        );
        $selected = ''; //$this->define_selected('effect');
        if (isset($this->layout['css'][$this->device][$this->posname]['linkunderlinehover'])) {
            $selected = $this->layout['css'][$this->device][$this->posname]['linkunderlinehover'];
        }
        $options = array();
        foreach ($effects as $key => $value) {
            $options[] = HtmlHelper::_('select.option', $key, $value);
        }
        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][linkunderlinehover]', '', 'value', 'text', $selected);
        return $this->return_html($return_op, "TPL_MARLEV_FONT_HOVER_UNDERLINE", 'linkunderlinehover', '', 'TPL_MARLEV_FONT_HOVER_UNDERLINE_DESC');
    }

    protected function font_honecolor()
    {
        $selected = $this->define_selected('honecolor');
        $return_op = '<input  class="minicolors minicolors-input"  type="text" size="10" value="' . $selected . '" name="layout[css][' . $this->device . '][' . $this->posname . '][honecolor]" >';
        return $this->return_html($return_op, "TPL_MARLEV_H1_COLOR_LABEL", 'honecolor', 'colors-box', 'TPL_MARLEV_H1_COLOR_DESC');
    }

    protected function font_htwocolor()
    {
        $selected = $this->define_selected('htwocolor');
        $return_op = '<input  class="minicolors minicolors-input"  type="text" size="10" value="' . $selected . '" name="layout[css][' . $this->device . '][' . $this->posname . '][htwocolor]" >';
        return $this->return_html($return_op, "TPL_MARLEV_H2_COLOR_LABEL", 'htwocolor', 'colors-box', 'TPL_MARLEV_H2_COLOR_DESC');
    }

    protected function font_htrecolor()
    {
        $selected = $this->define_selected('htrecolor');
        $return_op = '<input  class="minicolors minicolors-input"  type="text" size="10" value="' . $selected . '" name="layout[css][' . $this->device . '][' . $this->posname . '][htrecolor]" >';
        return $this->return_html($return_op, "TPL_MARLEV_H3_COLOR_LABEL", 'htrecolor', 'colors-box', 'TPL_MARLEV_H3_COLOR_DESC');
    }
    protected function font_h4color()
    {
        $selected = $this->define_selected('h4color');
        $return_op = '<input  class="minicolors minicolors-input"  type="text" size="10" value="' . $selected . '" name="layout[css][' . $this->device . '][' . $this->posname . '][h4color]" >';
        return $this->return_html($return_op, "TPL_MARLEV_H4_COLOR_LABEL", 'h4color', 'colors-box', 'TPL_MARLEV_H4_COLOR_DESC');
    }
    protected function font_h5color()
    {
        $selected = $this->define_selected('h5color');
        $return_op = '<input  class="minicolors minicolors-input"  type="text" size="10" value="' . $selected . '" name="layout[css][' . $this->device . '][' . $this->posname . '][h5color]" >';
        return $this->return_html($return_op, "TPL_MARLEV_H5_COLOR_LABEL", 'h4color', 'colors-box', 'TPL_MARLEV_H5_COLOR_DESC');
    }
    protected function font_h6color()
    {
        $selected = $this->define_selected('h6color');
        $return_op = '<input  class="minicolors minicolors-input"  type="text" size="10" value="' . $selected . '" name="layout[css][' . $this->device . '][' . $this->posname . '][h6color]" >';
        return $this->return_html($return_op, "TPL_MARLEV_H6_COLOR_LABEL", 'h6color', 'colors-box', 'TPL_MARLEV_H6_COLOR_DESC');
    }

    //Todo
    protected function font_lineheight()
    {
        return $this->sizer_show('font_lineheight', "TPL_MARLEV_LINE_HEIGHT_MENU", "font_lineheight", "", "TPL_MARLEV_LINE_HEIGHT_MENU_DESC");
    }
    protected function font_fontsize()
    {
        return $this->sizer_show('fontsize', "TPL_MARLEV_FONT_SIZE_MENU", "fontsize", "", "TPL_MARLEV_FONT_SIZE_MENU_DESC");
    }

    protected function font_honesize()
    {
        return $this->sizer_show('honesize', "TPL_MARLEV_H1_SIZE_LABEL", 'honesize', "", "TPL_MARLEV_H1_SIZE_DESC");
    }

    protected function font_htwosize()
    {
        return $this->sizer_show('htwosize', "TPL_MARLEV_H2_SIZE_LABEL", 'htwosize', "", "TPL_MARLEV_H2_SIZE_DESC");
    }

    protected function font_htresize()
    {
        return $this->sizer_show('htresize', "TPL_MARLEV_H3_SIZE_LABEL", 'htresize', "", "TPL_MARLEV_H3_SIZE_DESC");
    }
    protected function font_h4size()
    {
        return $this->sizer_show('h4size', "TPL_MARLEV_H4_SIZE_LABEL", 'h4size', "", "TPL_MARLEV_H4_SIZE_DESC");
    }
    protected function font_h5size()
    {
        return $this->sizer_show('h5size', "TPL_MARLEV_H5_SIZE_LABEL", 'h5size', "", "TPL_MARLEV_H5_SIZE_DESC");
    }
    protected function font_h6size()
    {
        return $this->sizer_show('h6size', "TPL_MARLEV_H6_SIZE_LABEL", 'h6size', "", "TPL_MARLEV_H6_SIZE_DESC");
    }

    //End todo

    protected function stile_borderstyle()
    {
        $effects = array(
            "" => Text::_("COM_TMARLEV_NONE"),
            "solid" => "solid",
            "dotted" => "dotted",
            "dashed" => "dashed",
            "double" => "double",
            "groove" => "groove",
            "ridge" => "ridge",
            "inset" => "inset",
            "outset" => "outset"
        );
        $selected = ''; //$this->define_selected('effect');
        if (isset($this->layout['css'][$this->device][$this->posname]['borderstyle'])) {
            $selected = $this->layout['css'][$this->device][$this->posname]['borderstyle'];
        }
        $options = array();
        foreach ($effects as $key => $value) {
            $options[] = HtmlHelper::_('select.option', $key, $value);
        }
        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][borderstyle]', '', 'value', 'text', $selected);
        return $this->return_html($return_op, "COM_TMARLEV_BORDER_STYLE", 'borderstyle', '', "COM_TMARLEV_BORDER_STYLE_DESC");
    }

    protected function stile_bordercolor()
    {
        $selected = $this->define_selected('bordercolor');
        $return_op = '<input  class="minicolors minicolors-input rgb-color"  type="text" size="10" value="' . $selected . '" name="layout[css][' . $this->device . '][' . $this->posname . '][bordercolor]" >';
        return $this->return_html($return_op, "COM_TMARLEV_BORDER_COLOR", 'bordercolor', 'colors-box', "COM_TMARLEV_BORDER_COLOR_DESC");
    }

    protected function stile_borderradius()
    {
        return $this->sizer_show('borderradius', "COM_TMARLEV_BORDER_RADIUS", 'borderradius');
    }
    protected function stile_bordertype()
    {
        $effects = array(
            "" => "Default (border)",
            "border" => "border",
            "border-top" => "border-top",
            "border-bottom" => "border-bottom",
            "border-left" => "border-left",
            "border-right" => "border-right",
            "border-top-bottom" => "border-top-bottom",
            "border-left-right" => "border-left-right",
        );
        $selected = ''; //$this->define_selected('effect');
        if (isset($this->layout['css'][$this->device][$this->posname]['bordertype'])) {
            $selected = $this->layout['css'][$this->device][$this->posname]['bordertype'];
        }
        $options = array();
        foreach ($effects as $key => $value) {
            $options[] = HtmlHelper::_('select.option', $key, $value);
        }
        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][bordertype]', '', 'value', 'text', $selected);
        return $this->return_html($return_op, "TPL_MARLEV_BORDER_TYPE", 'bordertype', '', 'TPL_MARLEV_BORDER_TYPE_DESC');
    }

    protected function stile_borderwidth()
    {
        return $this->sizer_show('borderwidth', "COM_TMARLEV_BORDER_WIDTH", 'borderwidth');
    }

    protected function stile_paddings()
    {
        $paddings = ["top", "bottom", "left", "right"];
        $return = "";
        foreach ($paddings as $key => $value) {
            $return .= $this->sizer_show('padding' . $value, "COM_TMARLEV_PADDING_" . strtoupper($value), "padding_" . $value);
        }
        return $return;
    }

    protected function stile_margins()
    {
        $paddings = ["top", "bottom"];
        $return = "";
        foreach ($paddings as $key => $value) {
            $return .= $this->sizer_show('margin' . $value, "TPL_MARLEV_MARGIN_" . strtoupper($value), "margin_" . $value);
        }
        return $return;
    }

///Tipo di effetto annimato
    protected function tab_option_effect()
    {
        $effects = array(
            $this->device . "-fadeInUp" => "Fade In Up",
            $this->device . "-fadeInDown" => "Fade In Down",
            $this->device . "-fadeInRight" => "Fade In Right",
            $this->device . "-fadeInLeft" => "Fade In Left",
            $this->device . "-zoomIn" => "Zoom In",
            $this->device . "-zoomInLeft" => "Zoom In Left",
            $this->device . "-zoomInRight" => "Zoom In Right",
            $this->device . "-bounceInLeft" => "Bounce In Left",
            $this->device . "-bounceInRight" => "Bounce In Right",
            $this->device . "-slideInUp" => "Slide In Up",
            $this->device . "-slideInDown" => "Slide In Down",
            $this->device . "-slideInLeft" => "Slide In Left",
            $this->device . "-slideInRight" => "Slide In Right"
        );
        $selected = ''; //$this->define_selected('effect');
        if (isset($this->layout['css'][$this->device][$this->posname]['effect'])) {
            $selected = $this->layout['css'][$this->device][$this->posname]['effect'];
        }
        $options = array();
        $options[] = HtmlHelper::_('select.option', "", Text::_("COM_TMARLEV_NONE"));
        foreach ($effects as $key => $value) {
            $options[] = HtmlHelper::_('select.option', $this->device . '-animated ' . $key, $value);
        }

        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][effect]', 'class="effect" data-type="' . $this->device
            . '" data-position="' . $this->posname .'"', 'value', 'text', $selected);
        return $this->return_html($return_op, "COM_TMARLEV_EFFECT", 'effect-box', '', "COM_TMARLEV_EFFECT_DESC");
    }

    protected function tab_option_effect_speed()
    {
        return $this->animation_speed_delay('efspeed', "COM_TMARLEV_EFFECT_SPEED", false, "TPL_MARLEV_MENU_SLIDE_SPEED_DESC");
    }

    protected function tab_option_effect_delay()
    {
        return $this->animation_speed_delay('efdelay', "COM_TMARLEV_EFFECT_DELAY", true, "COM_TMARLEV_EFFECT_DELAY_DESC");
    }

    //Seleziona tipo di background
    protected function choise_background_type()
    {

        $selected = $selected = $this->define_selected('btype');
        $options = array();
        $options[] = HtmlHelper::_('select.option', "", Text::_("COM_TMARLEV_NONE"));
        $options[] = HtmlHelper::_('select.option', "color", Text::_("COM_TMARLEV_BACKGROUND_TYPE_COLOR"));
        $options[] = HtmlHelper::_('select.option', "image", Text::_("COM_TMARLEV_BACKGROUND_TYPE_IMG"));

        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][btype]', 'class="background-type"', 'value', 'text', $selected);
        return $this->return_html($return_op, "COM_TMARLEV_TABBACKGROUND_TYPE", 'btype', '', "COM_TMARLEV_BACKGROUND_TYPE_DESC");
    }

    //seleziona background color
    protected function background_color()
    {
        $selected = $this->define_selected('bcolor');
        $return_op = '<input  class="minicolors minicolors-input rgb-color"  type="text" size="10" value="' . $selected . '" name="layout[css][' . $this->device . '][' . $this->posname . '][bcolor]" >';
        return $this->return_html($return_op, "COM_TMARLEV_SELECT_COLOR", 'bcolor', 'colors-box', "COM_TMARLEV_SELECT_COLOR_DESC");
    }

    //seleziona background image
    protected function background_image()
    {
        $uri = str_replace("administrator/", "", Uri::base());
        $selected = $this->define_selected('bimage');
        $return_img = ' <joomla-field-media class="field-media-wrapper" type="image" base-path="' . $uri . '" root-folder="images" url="' . Uri::root(true) . '/administrator/index.php?option=com_media&amp;view=media&amp;tmpl=component&amp;mediatypes=0&amp;asset=com_tmarlevv2&amp;author=&amp;fieldid={field-media-id}&amp;path=local-images:/' . $this->template . '_template" modal-container=".modal" modal-width="100%" modal-height="400px" input=".field-media-input" button-select=".button-select" button-clear=".button-clear" button-save-selected=".button-save-selected" preview="static" preview-container=".field-media-preview" preview-width="200" preview-height="200" supported-extensions="{&quot;images&quot;:[&quot;bmp&quot;,&quot;gif&quot;,&quot;jpg&quot;,&quot;png&quot;,&quot;jpeg&quot;,&quot;webp&quot;],&quot;audios&quot;:[],&quot;videos&quot;:[],&quot;documents&quot;:[]}">';
        $return_img .= ' <div id="imageModal_params_changeLogo" role="dialog" tabindex="-1" class="joomla-modal modal fade" data-url="' . Uri::root(true) . '/administrator/index.php?option=com_media&amp;view=media&amp;tmpl=component&amp;mediatypes=0&amp;asset=com_tmarlevv2&amp;author=&amp;fieldid={field-media-id}&amp;path=local-images:/' . $this->template . '_template" data-iframe="<iframe class=&quot;iframe&quot; src=&quot;' . Uri::root(true) . '/administrator/index.php?option=com_media&amp;amp;view=media&amp;amp;tmpl=component&amp;amp;mediatypes=0&amp;amp;asset=com_tmarlevv2&amp;amp;author=&amp;amp;fieldid={field-media-id}&amp;amp;path=local-images:/' . $this->template . '_template&quot; name=&quot;' . Text::_("JLIB_FORM_CHANGE_IMAGE") . '&quot; title=&quot;' . Text::_("JLIB_FORM_CHANGE_IMAGE") . '&quot; height=&quot;100%&quot; width=&quot;100%&quot;></iframe>">';
        $return_img .= '<div class="modal-dialog modal-lg jviewport-width80">';
        $return_img .= '<div class="modal-content">';
        $return_img .= '<div class="modal-header">';
        $return_img .= '<h3 class="modal-title">' . Text::_("JLIB_FORM_CHANGE_IMAGE") . '</h3>';
        $return_img .= ' <button type="button" class="btn-close novalidate" data-bs-dismiss="modal" aria-label="' . Text::_("JLIB_HTML_BEHAVIOR_CLOSE") . '">';
        $return_img .= '</button>';
        $return_img .= '</div>';
        $return_img .= '<div class="modal-body jviewport-height60">';
        $return_img .= '</div>';
        $return_img .= '<div class="modal-footer">';
        $return_img .= '<button type="button" class="btn btn-success button-save-selected">' . Text::_("JLIB_FORM_BUTTON_SELECT") . '</button><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">' . Text::_("JLIB_FORM_BUTTON_CLEAR") . '</button></div>';
        $return_img .= '</div>';
        $return_img .= '</div>';
        $return_img .= ' </div>';
        $return_img .= '<div class="field-media-preview">';
        if (!empty($selected)) {
            $return_img .= '<img src="' . Uri::base() . '/' . $selected . '" alt="">';
        } else {
            $return_img .= '<span class="field-media-preview-icon"></span>';
        }
        $return_img .= '</div>';
        $return_img .= '<div class="input-group">';
        $return_img .= '<input type="text" name="layout[css][' . $this->device . '][' . $this->posname . '][bimage]" id="params_changeLogo" value="' . $selected . '" readonly="readonly" class="form-control field-media-input">';
        $return_img .= '<button type="button" class="btn btn-success button-select">' . Text::_("JLIB_FORM_BUTTON_SELECT") . '</button>';
        $return_img .= '<button type="button" class="btn btn-danger button-clear"><span class="icon-times" aria-hidden="true"></span><span class="visually-hidden">' . Text::_("JLIB_FORM_BUTTON_CLEAR") . '</span></button>';
        $return_img .= ' </div>';
        $return_img .= '</joomla-field-media>';
        return $this->return_html($return_img, "COM_TMARLEV_SELECT_IMAGE", 'bimage', 'image-box', "COM_TMARLEV_SELECT_IMAGE_DESC");
    }

    protected function background_repeat()
    {

        $selected = $selected = $this->define_selected('brepeat');
        $options = array();
        $options[] = HtmlHelper::_('select.option', "", Text::_("COM_TMARLEV_NONE"));
        $options[] = HtmlHelper::_('select.option', "no-repeat", "no-repeat");
        $options[] = HtmlHelper::_('select.option', "repeat", 'repeat');
        $options[] = HtmlHelper::_('select.option', "repeat-x", "repeat-x");
        $options[] = HtmlHelper::_('select.option', "repeat-y", "repeat-y");

        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][brepeat]', '', 'value', 'text', $selected);
        return $this->return_html($return_op, "COM_TMARLEV_BACKGROUND_REPEAT", 'brepeat', 'image-box', "COM_TMARLEV_BACKGROUND_REPEAT_DESC");
    }

    protected function background_position()
    {

        $selected = $selected = $this->define_selected('bposition');
        $options = array();
        $options[] = HtmlHelper::_('select.option', "", Text::_("COM_TMARLEV_NONE"));
        $options[] = HtmlHelper::_('select.option', "left top", 'left top');
        $options[] = HtmlHelper::_('select.option', "left center", "left center");
        $options[] = HtmlHelper::_('select.option', "left bottom", "left bottom");
        $options[] = HtmlHelper::_('select.option', "right top", "right top");
        $options[] = HtmlHelper::_('select.option', "right center", 'right center');
        $options[] = HtmlHelper::_('select.option', "right bottom", "right bottom");
        $options[] = HtmlHelper::_('select.option', "center top", "center top");
        $options[] = HtmlHelper::_('select.option', "center center", "center center");
        $options[] = HtmlHelper::_('select.option', "center bottom", "center bottom");

        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][bposition]', '', 'value', 'text', $selected);
        return $this->return_html($return_op, "COM_TMARLEV_BACKGROUND_POSITION", 'bposition', 'image-box', "COM_TMARLEV_BACKGROUND_POSITION_DESC");
    }

    protected function background_attachment()
    {

        $selected = $selected = $this->define_selected('battach');
        $options = array();
        $options[] = HtmlHelper::_('select.option', "", Text::_("COM_TMARLEV_NONE"));
        $options[] = HtmlHelper::_('select.option', "fixed", 'Fixed');
        $options[] = HtmlHelper::_('select.option', "scroll", "scroll");

        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][battach]', '', 'value', 'text', $selected);
        return $this->return_html($return_op, "Background attachment", 'battach', 'image-box', "COM_TMARLEV_BACKROUND_ATTACH_DESC");
    }

//        =============
//        ============
//        Repeated functions
//        ==============
//        ==============

    protected function sizer_show($param, $lang, $controlsidentifer, $class = "", $tooltip = null, $image = null)
    {
        if ($tooltip === null) {
            $tooltip = $lang . "_DESC";
        }
        $selected = $this->define_selected($param);
        $return_op = '<input  type="text" size="10" value="' . $selected . '" name="layout[css][' . $this->device . '][' . $this->posname . '][' . $param . ']" >&nbsp;<span style="font-size:14px;">px</span>';
        return $this->return_html($return_op, $lang, $controlsidentifer, $class, $tooltip, $image);
    }

    protected function define_selected($name, $selected = '')
    {
        if (isset($this->layout['css'][$this->device][$this->posname][$name])) {
            $selected = $this->layout['css'][$this->device][$this->posname][$name];
        }
        return $selected;
    }

    protected function return_html($content, $lang, $controlsidentifer, $css_class = '', $tooltip = null, $image = null)
    {
        $tooltip_top = array("htresize", "htwosize", "btype", "brepeat", "bposition", "battach", "shadowcolorhover", "shadowspreadhover", "shadowblurhover", "margin_bottom", "margin_top");
        $tooltip_position = "right";
        if (in_array($controlsidentifer, $tooltip_top)) {
            $tooltip_position = "top";
        }
        //if ($image != null) {
        //  $image = '<br/><img src="' . JPATH_ROOT . '/templates/' . $this->template . '/images/systems/' . $image . '" />';
        //}
        $return = '';
        $return = '<div class="control-group ' . $css_class . '">';
        $return .= '<div class="control-label"><label class="hasPopover" title="' . Text::_($tooltip)  . '" data-title="' . Text::_($lang) . '" data-placement="' . $tooltip_position . '">' . Text::_($lang) . '</label></div>';
        //$return .= '<div class="control-label"><label class="hasPopover" data-contenssst="' . Text::_($tooltip) . $image . '" data-original-title="' . Text::_($lang) . '" data-placement="' . $tooltip_position . '">' . Text::_($lang) . '</label></div>';
        $return .= '<div data-identifier="' . $controlsidentifer . '" class="controls ' . $controlsidentifer . '">' . $content . '</div>';
        $return .= '</div>';
        return $return;
    }

    //velocita per effetto annimato
    protected function animation_speed_delay($param, $name, $with_zero, $tooltip)
    {
        $effects = array(
            "0.1" => "0.1 sec.",
            "0.2" => "0.2 sec.",
            "0.3" => "0.3 sec.",
            "0.4" => "0.4 sec.",
            "0.5" => "0.5 sec.",
            "0.6" => "0.6 sec.",
            "0.7" => "0.7 sec.",
            "0.8" => "0.8 sec.",
            "0.9" => "0.9 sec.",
            "1" => "1 sec.",
            "1.2" => "1.2 sec.",
            "1.5" => "1.5 sec.",
            "1.8" => "1.8 sec.",
            "2" => "2 sec.",
            "2.5" => "2.5 sec.",
            "3" => "3 sec.",
            "3.5" => "3.5 sec.",
            "4" => "4 sec.",
            "5" => "5 sec.",
        );
        $selected = $this->define_selected($param);
        $options = array();

        if ($with_zero == true) {
            $options[] = HtmlHelper::_('select.option', "0", "0");
        }

        foreach ($effects as $key => $value) {
            $options[] = HtmlHelper::_('select.option', $key, $value);
        }

        $return_op = HtmlHelper::_('select.genericlist', $options, 'layout[css][' . $this->device . '][' . $this->posname . '][' . $param . ']',  'class="'.$param.'" data-type="' . $this->device
            . '" data-position="' . $this->posname .'" ',  'value', 'text', $selected);
        return $this->return_html($return_op, $name, $param.'-box', '', $tooltip);
    }

}
