<?php

/**
 *
 * @extension       Marlev TM V2
 * @author          Lev Milicenco<support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2017 marlev.it All Rights Reserved

 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
//for_use
defined('_JEXEC') or die('Restricted access');


class JFormFieldyrminifiercomponents extends ListField
{

    protected $type = 'yrminifiercomponents';

    public function getOptions()
    {
        $escludefromlist = array('com_tmarlevv2', 'com_inmarlev', 'com_actionlogs', 'com_associations', 'com_contenthistory',
            'com_scheduler', 'com_redirect', 'com_banner');
        $include = array('com_config','com_content');
        foreach($include as $incl=>$val){
            $this->load_langs($val);
            $options[] = HtmlHelper::_('select.option', $val, Text::_($val));
        }


        $components = $this->getyrminifier_components();
        foreach ($components as $key) {
            if (!in_array($key->element, $escludefromlist)) {
                $this->load_langs($key->element);
                $options[] = HtmlHelper::_('select.option',  $key->element, Text::_($key->name));
            }
        }
        return $options;
    }

    function load_langs($extension)
    {
        $lang = Factory::getApplication()->getLanguage();
        if (file_exists(JPATH_ADMINISTRATOR . '/components/' . $extension . '/language/') && is_dir(JPATH_ADMINISTRATOR . '/components/' . $extension . '/language/')) {
            $base_dir = JPATH_ADMINISTRATOR . '/components/' . $extension . '/';
        } else {
            $base_dir = JPATH_ADMINISTRATOR ;
        }
        $reload = true;
        $lang->load($extension, $base_dir, $lang->get("tag"), $reload);
    }

    function getyrminifier_components()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('element,name');
        $query->from('#__extensions');
        $query->where('protected=' . $db->Quote(0));
        $query->where('type=' . $db->Quote('component'));
        //$query->where('element!=' . $db->Quote('com_tmarlevv2'));
        //$query->where('element!=' . $db->Quote('com_inmarlev'));
        // $query->where('element != com_tmarlevv2');
        //$query->where('element != com_inmarlev');
//        $query->order($db->quoteName('ordering') . 'DESC');
        $db->setQuery($query);
        $components = $db->loadObjectList();
        return $components;
    }

}
