
<?php
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
//for_use

defined('_JEXEC') or die;
HtmlHelper::_('bootstrap.framework');
$twofactormethods = JAuthenticationHelper::getTwoFactorMethods();
$app = Factory::getApplication();

?>
<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <jdoc:include type="metas"/>
    <?php require 'lib/index_inc.php'; ?>
    <link rel="stylesheet" href="<?php echo $template; ?>css/bootstrap.css?" type="text/css"/>
    <link rel="stylesheet" href="<?php echo $template; ?>css/offline.css?" type="text/css"/>
    <script src="<?php echo $this->baseurl; ?>/media/vendor/jquery/js/jquery.min.js" type="text/javascript"></script>
    <script src="<?php echo $template; ?>js/offline.js?" type="text/javascript"></script>
</head>
<?php $offline = new ml_template_helper(); ?>
<body id='ml_offline'>
<div class="container">
    <div class="row">

    <div class="col-md-12 col-lg-12 col-sm-12 col-12 offline-logo">
        <img src="<?php echo $logo ?>" height="<?php echo $params->get('logo-height', 45) ?>"
             width="<?php echo $params->get('logo-width', 216) ?>" alt="<?php echo $params->get('sitetitle') ?>"/>
    </div>
    <div class="col-md-12 col-lg-12 col-sm-12 col-12">

        <?php echo $offline->offline_text($params, $app); ?>
    </div>
    <div class="col-md-12 col-lg-12 col-sm-12 col-12">
        <?php echo $offline->inizializze_counter($params); ?>
    </div>
    <div class="col-md-12 col-lg-12 col-sm-12 col-12">
        <div class="offline-login"><i class="fa fa-user" aria-hidden="true"></i>
            &nbsp;<?php echo Text::_("TPL_OFFLINE_ADMIN_LOGIN") ?></div>
    </div>

    <div class="col-md-6 col-lg-6 col-xl-6 col-xxl-6 offset-md-3 offset-lg-3 offset-xl-3 offset-xxl-3 col-sm-12 col-12 login-box">

        <jdoc:include type="message"/>
        <form action="<?php echo Route::_('index.php', true); ?>" method="post" id="form-login">
            <fieldset>
                <label for="username"><?php echo Text::_('JGLOBAL_USERNAME'); ?></label>
                <input name="username" id="username" class="form-control" type="text" title="<?php echo Text::_('JGLOBAL_USERNAME'); ?>"/>

                <label for="password"><?php echo Text::_('JGLOBAL_PASSWORD'); ?></label>
                <input type="password" name="password" class="form-control" id="password"
                       title="<?php echo Text::_('JGLOBAL_PASSWORD'); ?>"/>

                <?php if (count($twofactormethods) > 1) : ?>
                    <label for="secretkey"><?php echo Text::_('JGLOBAL_SECRETKEY'); ?></label>
                    <input type="text" class="form-control" name="secretkey" id="secretkey"
                           title="<?php echo Text::_('JGLOBAL_SECRETKEY'); ?>"/>
                <?php  endif; ?>
                <div class="offline-login-button">
                    <input type="submit" name="Submit" class="btn btn-secondary btn-lg"
                           value="<?php echo Text::_('JLOGIN'); ?>"/>
                </div>
                <input type="hidden" name="option" value="com_users"/>
                <input type="hidden" name="task" value="user.login"/>
                <input type="hidden" name="return" value="<?php echo base64_encode(Uri::base()); ?>"/>
                <?php echo HtmlHelper::_('form.token'); ?>
            </fieldset>
        </form>
        <div class="clearfix"></div>
    </div>
    <div class="col-md-12 col-lg-12 col-sm-12 col-xs-12">
        <?php echo $offline->offline_copyright($params); ?>
    </div>
</div>
</div>
<div class="clearfix"></div>
</body>
</html>