
<?php
use Joomla\CMS\Filesystem\Path;
//for_use


/**
 * @extension       Marlev Template
 * @author          Lev Milicenco <support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2017 marlev.it All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
require_once JPATH_ROOT . '/administrator/components/com_tmarlevv2/src/Helper/loader.php';
use Marlev\Component\Tmarlevv2\Administrator\Helper\marlev_fonts;
defined('_JEXEC') or die;

class marlev_templatecss {

    public $template;
    public $id;
    public $fields;
    public $params;
    public $layout;
    public $mediapc_start;
    public $mediapc_end;
    public $default_value;

    function __construct($id, $template, $layout, $params) {
        $this->template = $template;
        $this->id = $id;
        $this->layout = $layout;
        $this->params = $params;
        $this->mediapc_start = '@media (min-width: 1025px) and (max-width: 1280px),(min-width: 1281px) {';
        $this->media_end = '} ' . PHP_EOL;
    }

    function write_tocss($elements) {
        $css = "";

          foreach ($elements as $key => $value) {
            $get_field = $this->fields[$key];
            if ($get_field['assigned'] == 'function') {
                $css .= $this->$key($value);
            } else {
                $getvalue = $this->define_value($key);
                if ($getvalue !== false) {
                    $important = "";
                    if(isset($get_field['important'])){
                        $important = " !important";
                    }
                    $css .= $get_field['assigned'] . '{' . $get_field['regola'] . ':' . $getvalue . ' '.$important.';}';
                    if("color" ==  $get_field['regola'] && ($get_field['assigned'] == "h1" || $get_field['assigned'] == "h2" || $get_field['assigned'] && "h3")){
                        $css .= $get_field['assigned'] . ' a{' . $get_field['regola'] . ':' . $getvalue . ' '.$important.';}';
                    }
                }
            }
        }

        return $css;
    }

     protected function menuslidehshadow($value) {

           $return = "";
        if (isset($this->params['menuslidehshadow']) && isset($this->params['menuslidevshadow'])) {
            $inset = (isset($this->params['menuslideshadow']) && !empty($this->params['menuslideshadow'])) ? $this->params['menuslideshadow'] : "";
            $spread = (isset($this->params['menuslidespread']) && !empty($this->params['menuslidespread'])) ? $this->params['menuslidespread'] . "px " : "";
            $blur = (isset($this->params['menuslideblur']) && !empty($this->params['menuslideblur'])) ? $this->params['menuslideblur'] . "px " : "";
            $color = (isset($this->params['menuslideshadowcolor']) && !empty($this->params['menuslideshadowcolor'])) ? $this->params['menuslideshadowcolor']." " : "";
            $return .= '#ml-navigation-menu-slide {';

            $return .= 'box-shadow:' . $this->params['menuslidehshadow'] . "px " . $this->params['menuslidevshadow'] . "px " . $blur . $spread . $color . $inset . ';';
            $return .= '-webkit-box-shadow:' . $this->params['menuslidehshadow'] . "px " . $this->params['menuslidevshadow'] . "px " . $blur . $spread . $color . $inset . ';';
            $return .= '-moz-box-shadow:' . $this->params['menuslidehshadow'] . "px " . $this->params['menuslidevshadow'] . "px " . $blur . $spread . $color . $inset . ';';

            $return .= "}";

        }
        return $return;

    }

    protected function colorhovermenu($value) {
        $defined = $this->define_value('colorhovermenu');
        $return = '#ml-navigation-menu .nav li > a:hover, #ml-navigation-menu .nav > li > span:hover{';
        $return .= 'color:' . $defined;
        $return .= '}';
        $return .= '#ml-navigation-menu .nav ul{';
        $return .= 'border-top:3px solid ' . $defined;
        $return .= '}';
        return $return;

    }
      protected function colorhovermenuul($value) {
        $defined = $this->define_value('colorhovermenuul');
        $return = '#ml-navigation-menu .nav li ul li > a:hover, #ml-navigation-menu .nav > li ul li> span:hover{';
        $return .= 'color:' . $defined;
        $return .= '}';
        $return .= '#ml-navigation-menu .nav ul li ul{';
        $return .= 'border-left:3px solid ' . $defined;
        $return .= '}';
        return $return;

    }

     protected function colorhovermenuslide($value) {
        $defined = $this->define_value('colorhovermenuslide');
        $return = '#ml-navigation-menu-slide .nav li > a:hover, #ml-navigation-menu-slide .nav > li > span:hover{';
        $return .= 'color:' . $defined;
        $return .= '}';
        $return .= '#ml-navigation-menu-slide .nav ul{';
        $return .= 'border-top:3px solid ' . $defined;
        $return .= '}';
        return $return;

    }
      protected function colorhovermenuulslide($value) {
        $defined = $this->define_value('colorhovermenuulslide');
        $return = '#ml-navigation-menu-slide .nav li ul li > a:hover, #ml-navigation-menu-slide .nav > li ul li> span:hover{';
        $return .= 'color:' . $defined;
        $return .= '}';
        $return .= '#ml-navigation-menu-slide .nav ul li ul{';
        $return .= 'border-left:3px solid ' . $defined;
        $return .= '}';
        return $return;

    }

    protected function font($value) {
        $get_fonts = new marlev_fonts();
        $avvaiable_fonts = $get_fonts->avvaiable_fonts();
        $return = 'body,html {';
        $return .= 'font-family:' . $avvaiable_fonts[$value] . ';';
        $return .= 'color:' . $this->define_value('fontcolor') . ';';
        $return .= '}';
        $return .= ' a{';
        $return .= 'color:' . $this->define_value('linkcolor') . ';';
        $return .= 'text-decoration:' . $this->define_value('linkunderline') . ';';
        $return .= '}';
        $return .= ' a:hover{';
        $return .= 'color:' . $this->define_value('linkcolorhover') . ';';
        $return .= 'text-decoration:' . $this->define_value('linkunderlinehover') . ';';
        $return .= '}';
        return $return;
    }

    //controlla se esiste default value in xml e restituisce se nuovo paramentro empty
    protected function define_value($option) {
        if (!isset($this->params[$option]) && empty($this->params[$option])) {

            if (isset($this->fields[$option]["default"]) && !empty($this->fields[$option]["default"])) {
                return $this->fields[$option]["default"];
            } else {
                return false;
            }
        } else {

            return $this->params[$option];
        }
    }

    protected function pcmenulayout($value) {
        $return = '';

        if ($value == 'fixed') {
            $return .= $this->mediapc_start . '#logo_menu_subsection{position:fixed; left:0; top:0;width:100%;z-index:9999;}' . $this->media_end;
            //implemento per logo e menu quando sono nello stesso container
            //si elabora le dimensioni e si aggiunge altro stile
        }
        $container_fluid = ($this->layout['width']['logo_menu'] == "container-fluid") ? true : false;
        if ($this->layout['pc']['logo'] + $this->layout['pc']['menu'] > 12) {
            //se container e' fluid aggiungiamo alla classe del menu margins -
            if ($container_fluid) {
                $return .= $this->mediapc_start . '#ml-navigation-menu{margin-right:-30px; margin-left:-30px; padding-left:30px; padding-right:30px;min-height:60px;}' . $this->media_end;
            }
        } else {
            if ($container_fluid) {
                $return .= $this->mediapc_start . '#ml-navigation-menu{margin-right:-30px;min-height:60px;; padding-right:30px}' . $this->media_end;
            }
            $return .= $this->mediapc_start . '#logo_menu_subsection{min-height:60px;}' . $this->media_end;
        }

        return $return;
    }

    protected function sfondomenuslide($value) {
        $return = "";

        if (!empty($value)) {
            $return .= $this->mediapc_start . '.ml-menu-fixed{background-color:' . $value . ';}' . $this->media_end;
        }

        return $return;
    }

    protected function slidelogospeed($value) {
        $return = "";
        if ($this->params['slidelogoeffect'] == "null" || $this->params['show_logo_slide'] == "hide") {
            return $return;
        }

        $return .= $this->mediapc_start . '.append-logo-slide{ 
            animation-duration: ' . $value . 's!important; -moz-animation-duration: ' . $value . 's !important;
            -webkit-animation-duration: ' . $value . 's !important;;
            -o-animation-duration: ' . $value . 's !important;}' . $this->media_end;

        return $return;
    }

    protected function menu_slide_speed($value) {
        $return = "";

        if ($this->params['pcmenulayout'] !== "slide") {
            return $return;
        }

        $return .= $this->mediapc_start . '#ml-navigation-menu-slide{ 
            animation-duration: ' . $value . 's !important;-moz-animation-duration: ' . $value . 's !important;
            -webkit-animation-duration: ' . $value . 's !important;
            -o-animation-duration: ' . $value . 's !important;}' . $this->media_end;

        return $return;
    }

    function get_names() {
        $path = Path::clean(JPATH_SITE . '/templates/' . $this->template . '/admin/styles.xml');
        $xml = simplexml_load_file($path);
        $this->fields = array();
        $names = array();
        foreach ($xml->fieldset->field as $k => $v) {
            foreach ($v->attributes() as $name => $value) {
                if ($name == "writecss") {
                    $a = (array) $v->attributes();
                    $this->fields[$a['@attributes']["name"]] = $a['@attributes'];
                    $names[] = $a['@attributes']["name"];
                }
            }
        }

        return $names;
    }

//    function get_default() {
//        $path = Path::clean(JPATH_SITE . '/templates/' . $this->template . '/admin/styles.xml');
//        $xml = simplexml_load_file($path);
//        $this->fields = array();
//        $names = array();
//        foreach ($xml->fieldset->field as $k => $v) {
//            foreach ($v->attributes() as $name => $value) {
//                if ($name == "default") {
//                    $a = (array) $v->attributes();
//                    $names[$a['@attributes']["name"]] = $a['@attributes']["default"];
//                }
//            }
//        }
//        //file_put_contents("/var/www/html/vars.txt", print_r($names, true));
//        return $names;
//    }
}
