<?php

/**
 *
 * @extension       Marlev - Template Manager
 * @author          Lev Milicenco<support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2017 marlev.it All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.view');
include JPATH_COMPONENT_ADMINISTRATOR . "/helpers/helpers.php";

class Tmarlevv2ViewTemplate extends JViewLegacy {

    public $getlayout;

    public function display($tpl = null) {
        $input = JFactory::getApplication()->input;
        $this->installtype = $input->getString("installtype", 0);
        $loadposition = $input->getString("loadposition", 0);
        $loadlayout = $input->getString("loadlayout", 0);
        $this->load = $this->get('Load_Template');
        if ($loadposition == 1) {

            $input->set('tmpl', 'component');
            $tpl = "loadposition";
            $this->layout = $this->get('layout');
            $this->layoutid = $this->get('layoutid');
        } elseif ($loadlayout == 1) {
            $this->layout = $this->get('layout');
            $this->layoutid = $this->get('layoutid');
            $input->set('tmpl', 'component');
            $tpl = "layout";
        } else {
            //get layout for navigation in fixed saved cancell box
            require_once JPATH_ROOT . DS . "templates" . DS . $this->load->template . DS . 'lib' . DS . 'layout.php';

            $this->getlayout = defined_layout();
            $this->layout_sections = $this->get_layout_sections_forselect($this->getlayout->sections);
            $this->layout_positionsblock = $this->get_layout_positions_forselect($this->getlayout->sections);
            //end get layout
            $this->message = $this->get('Message');

            $this->form = $this->get('Form');
            $this->presets = $this->get('Presets');
            $this->lang_params = $this->get('Lang_params');
            $this->plugins = $this->get('Plugins');
            $this->tparams = $this->get('Tparams');
            $this->gettype = $this->get('Ttype');
            $this->modules = $this->get('Modules');
            $this->type = $this->ttype($this->gettype);
            $this->links = $this->get_links($this->type);
            $this->filecached = cachedcssjs_files::css_js_esclude($this->tparams);
            $custom_css = JPATH_SITE . "/templates/" . $this->load->template . "/custom/css.css";

            if (file_exists($custom_css)) {
                $this->customcss = file_get_contents($custom_css);
            } else {
                $this->customcss = false;
            }
            $custom_js = JPATH_SITE . "/templates/" . $this->load->template . "/custom/js.js";

            if (file_exists($custom_js)) {
                $this->customjs = file_get_contents($custom_js);
            } else {
                $this->customjs = false;
            }

            if (count($errors = $this->get('Errors'))) {
                JError::raiseError(500, implode("\n", $errors));
                return false;
            }
        }
        $this->positions = "Unlimited";



        parent::display($tpl);
    }

   

    protected function get_layout_sections_forselect($sections) {
        $options = array();
        $options[] = JHTML::_('select.option', "loadlayout", JText::_("COM_TMARLEV_SECTIONS"));
        foreach ($sections as $name => $positions) {
            $options[] = JHTML::_('select.option', $name . "_section", ucfirst($name));
        }
        return JHTML::_('select.genericlist', $options, ' ', 'class="layout-fast-navigate-section"', 'value', 'text', '');
    }

    protected function get_layout_positions_forselect($sections) {
        $options = array();
        $options[] = JHTML::_('select.option', "loadlayout", JText::_("COM_TMARLEV_POSITIONS"));
        foreach ($sections as $name => $positions) {
            foreach ($positions as $key => $value) {
                $options[] = JHTML::_('select.option', "pos_" . $value, ucfirst($value));
            }
        }
        return JHTML::_('select.genericlist', $options, ' ', 'class="layout-fast-navigate-blocks"', 'value', 'text', '');
    }

    protected function addToolbar() {

        JToolbarHelper::title("", "marlev_logo");
        if (JFactory::getUser()->authorise('core.manage', 'com_templates')) {
            JToolbarHelper::apply('template.apply');
            JToolbarHelper::save('template.save');
            JToolbarHelper::cancel('template.cancel');
        }
    }

    protected function ttype($type) {
        if ($type == false) {
            return false;
        } else {
            return "[" . ucfirst($type) . " Edition]";
        }
    }

    protected function get_links($value) {
        $return = new stdClass();
        if ($value == false) {
            $return->support = 'https://marlev.it/support.php';
            $return->download = 'https://marlev.it/';
        } else {
            $return->support = 'https://itroom.it/clienti/submitticket.php';
            $return->download = 'https://itroom.it/Template-Joomla';
        }
        return $return;
    }

//    function tab_options($posdata, $posname) {
//        $return = "";
//        $options = new ml_tab_options($posname, $this->layout, $this->load->template);
//        foreach ($posdata->tab_options as $key => $value) {
//
//            if ($key == "effect") {
//                $return .= $options->tab_option_effect();
//                $return .= $options->tab_option_effect_speed();
//            }
//            if ($key == "backgroundall") {
//                $return .= $options->choise_background_type();
//                $return .= $options->background_color();
//                $return .= $options->background_image();
//                //$return .= $this->background_repeat($posdata, $posname);
//            }
//        }
//        return $return;
//    }
}
