<?php

/**
 *
 * @extension       Marlev TM V2
 * @author          Lev Milicenco<support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2017 marlev.it All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
defined('_JEXEC') or die('Restricted access');
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');
require_once (JPATH_COMPONENT_ADMINISTRATOR . "/functions/layout.php");

class JFormFieldsocialpositions extends JFormFieldList {

    protected $type = 'socialpositions';

    public function getOptions() {
        $gettemplate = $this->load_template();
        $layout = $this->getthislayout($gettemplate->id);
        $get_positions = new ml_layout($layout, $gettemplate->template);
        require_once JPATH_ROOT . DS . "templates" . DS . $gettemplate->template . DS . 'lib' . DS . 'layout.php';
        $defined_layout = defined_layout();
        $options = array();
        $options[] = JHTML::_('select.option', "null", JText::_("DISABLE"));
        $options[] = JHTML::_('select.option', "socialleft", "Left Fixed");
        $options[] = JHTML::_('select.option', "socialright", "Right Fixed");
        foreach ($defined_layout->sections as $key) {
            foreach ($key as $get => $section) {
                $explode = explode(",", $get_positions->layout['positions'][$section]);
                foreach ($explode as $key => $value) {
                    $value = trim($value);
                    $options[] = JHTML::_('select.option', $value, $value);
                }
            }
        }



        return $options;
    }

    function getthislayout($id) {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('layout,id');
        $query->from('#__tmarlevv2_layout');
        $query->where('tid=' . $db->Quote($id));
        $db->setQuery($query);
        $layout = $db->loadObjectList();
        $return = false;
        if (isset($layout[0]->layout)) {
            $registry = new JRegistry;
            $registry->loadString($layout[0]->layout);
            $return = $registry->toArray();
            $this->layoutid = $layout[0]->id;
        }

        return $return;
    }

    static function load_template() {
        $input = JFactory::getApplication()->input;
        $tid = $input->getInt("id");
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('a.template');
        $query->from('#__template_styles AS a');
        $query->where('a.id=' . $db->Quote($tid));
        $db->setQuery($query);
        $template = $db->loadResult();

        $return = new stdClass();
        $return->template = $template;
        $return->id = $tid;
        return $return;
    }

}
