<?php

/**
 *
 * @extension       Marlev - Template Manager
 * @author          Lev Milicenco<support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2017 marlev.it All Rights Reserved

 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */
namespace Marlev\Component\Tmarlevv2\Administrator\View\Template;
require_once JPATH_ROOT . '/administrator/components/com_tmarlevv2/src/Helper/loader.php';
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
use Marlev\Component\Tmarlevv2\Administrator\Helper\cachedcssjs_files;
use  Marlev\Component\Tmarlevv2\Administrator\Controller\TemplateController;
//for_use

defined('_JEXEC') or die;
class HtmlView extends BaseHtmlView{

    public $getlayout;

    public function display($tpl = null)
    {
        $input = Factory::getApplication()->input;
        $this->installtype = $input->getString("installtype", "null");
        if($this->installtype == "upgraded"){
            $this->installtype = "install";
        }
        if($this->installtype == "install"){
            $this->get('FreshInstall_installPreset');
        }

        $loadposition = $input->getString("loadposition", 0);
        $loadlayout = $input->getString("loadlayout", 0);
        $posconfig = $input->getInt("posconfig", 0);
        $this->load = $this->get('Load_Template');
        if($this->installtype == "update"){
            $controller = new TemplateController();
            $controller->clearcache($this->load->template);
        }
        $this->update = $this->get('Update_Template');
        //todo
        $this->layout = $this->get('layout');
        $this->layoutid = $this->get('layoutid');
        if (!Factory::getApplication()->getIdentity()->authorise('core.manage', 'com_templates')) {
            Factory::getApplication()->redirect(Uri::base() . 'index.php', Text::_('JERROR_ALERTNOAUTHOR'));
            return false;
        }
        if ($loadposition == 1) {

            $input->set('tmpl', 'component');
            $tpl = "loadposition";
        }
        if ($posconfig == 1) {

            $input->set('tmpl', 'component');
            $tpl = "posconfig";
        }
        elseif ($loadlayout == 1) {
            $input->set('tmpl', 'component');
            $tpl = "layout";
        } else {
            if (file_exists(JPATH_ROOT . DS . "templates" . DS . $this->load->template . DS . 'lib' . DS . 'layout.php')) {
                //get layout for navigation in fixed saved cancell box
                require_once JPATH_ROOT . DS . "templates" . DS . $this->load->template . DS . 'lib' . DS . 'layout.php';
                $this->getlayout = defined_layout();
                $this->layout_sections = $this->get_layout_sections_forselect($this->getlayout->sections);
                $this->layout_positionsblock = $this->get_layout_positions_forselect($this->getlayout->sections);
                $this->layout_loaded = true;
                //end get layout
            } else {
                $this->layout_loaded = false;
            }
            $this->message = $this->get('Message');

            $this->form = $this->get('Form');
            $this->presets = $this->get('Presets');
            $this->lang_params = $this->get('Lang_params');
            $this->plugins = $this->get('Plugins');
            $this->tparams = $this->get('Tparams');
            $this->gettype = $this->get('Ttype');
            $this->modules = $this->get('Modules');
            $this->contact_privacy = $this->get('ContactPrivacy');
            $this->contact_privacy_article = $this->get('ContactPrivacyArticles');
            $this->type = $this->ttype($this->gettype);
            $this->links = $this->get_links($this->type);
            $this->filecached = cachedcssjs_files::css_js_esclude($this->tparams);
            $custom_css = JPATH_SITE . "/templates/" . $this->load->template . "/custom/css.css";

            if (file_exists($custom_css)) {
                $this->customcss = file_get_contents($custom_css);
            } else {
                $this->customcss = false;
            }
            $custom_js = JPATH_SITE . "/templates/" . $this->load->template . "/custom/js.js";

            if (file_exists($custom_js)) {
                $this->customjs = file_get_contents($custom_js);
            } else {
                $this->customjs = false;
            }

            if (count($errors = $this->get('Errors'))) {
                return Factory::getApplication()->enqueueMessage(implode("\n", $errors), 'error');
            }
        }
        $this->positions = "Unlimited";


        parent::display($tpl);
    }


    protected function get_layout_sections_forselect($sections)
    {
        $options = array();
        $options[] = HtmlHelper::_('select.option', "loadlayout", Text::_("COM_TMARLEV_SECTIONS"));
        foreach ($sections as $name => $positions) {
            $options[] = HtmlHelper::_('select.option', $name . "_section", ucfirst($name));
        }
        return HtmlHelper::_('select.genericlist', $options, ' ', 'class="layout-fast-navigate-section"', 'value', 'text', '');
    }

    protected function get_layout_positions_forselect($sections)
    {
        $options = array();
        $options[] = HtmlHelper::_('select.option', "loadlayout", Text::_("COM_TMARLEV_POSITIONS"));
        foreach ($sections as $name => $positions) {
            foreach ($positions as $key => $value) {
                $options[] = HtmlHelper::_('select.option', "pos_" . $value, ucfirst($value));
            }
        }
        return HtmlHelper::_('select.genericlist', $options, ' ', 'class="layout-fast-navigate-blocks"', 'value', 'text', '');
    }

    protected function addToolbar()
    {
        Factory::getApplication()->input->set('hidemainmenu', true);
        ToolbarHelper::title("", "marlev_logo");
        if (Factory::getUser()->authorise('core.manage', 'com_templates')) {
            ToolbarHelper::apply('template.apply');
            ToolbarHelper::save('template.save');
            ToolbarHelper::cancel('template.cancel');
        }
    }

    protected function ttype($type)
    {
        if ($type == false) {
            return false;
        } else {
            return "[" . ucfirst($type) . " Edition]";
        }
    }

    protected function get_links($value)
    {
        $return = new \stdClass();
        if ($value == false) {
            $return->support = 'https://marlev.it/support.php';
            $return->download = 'https://marlev.it/';
        } else {
            $return->support = 'https://itroom.it/clienti/submitticket.php';
            $return->download = 'https://itroom.it/Template-Joomla';
        }
        return $return;
    }

//    function tab_options($posdata, $posname) {
//        $return = "";
//        $options = new ml_tab_options($posname, $this->layout, $this->load->template);
//        foreach ($posdata->tab_options as $key => $value) {
//
//            if ($key == "effect") {
//                $return .= $options->tab_option_effect();
//                $return .= $options->tab_option_effect_speed();
//            }
//            if ($key == "backgroundall") {
//                $return .= $options->choise_background_type();
//                $return .= $options->background_color();
//                $return .= $options->background_image();
//                //$return .= $this->background_repeat($posdata, $posname);
//            }
//        }
//        return $return;
//    }
}
