<?php
namespace Marlev\Component\Tmarlevv2\Administrator\Helper;
/**
 *
 * @extension       Marlev - Template Manager
 * @author          Lev Milicenco<support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2017 marlev.it All Rights Reserved

 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
//for_use
defined('_JEXEC') or die;
use Joomla\CMS\Factory;
//include 'options_options.php';
//include 'device_options.php';


class ml_layout
{

    public $getlayout;
    public $layout;
    public $template_name;
    public $editconfigid = array();


    function __construct($saved_layout, $template_name)
    {
        require_once JPATH_ROOT . DS . "templates" . DS . $template_name . DS . 'lib' . DS . 'layout.php';

        $this->getlayout = defined_layout();
        $this->layout = $saved_layout;
        $this->template_name = $template_name;
    }

    function return_layout()
    {
        return $this->getlayout;
    }

    function elabora_posdata($name)
    {

        if (!isset($this->getlayout->positions[$name]))
            return false;
        $return = new \stdClass();
        $return->poslayout = $this->getlayout->positions[$name];
        $params = $this->get_layout_params($return);
        $return->defpositions = $return->poslayout['defpositions'];
        if ($this->layout == false) {
            $return->width = $return->poslayout['width'];
        } else {
            if (isset($this->layout['defcollayout'][$name])) {
                $return->defcollayout = explode(",", $this->layout['defcollayout'][$name]);
                $return->tabcollayout = explode(",", $this->layout['tabcollayout'][$name]);
                $return->mobcollayout = explode(",", $this->layout['mobcollayout'][$name]);
                $return->defpositions = explode(",", $this->layout['positions'][$name]);
            }
            $return->width = (isset($this->layout['width'][$name])) ? $this->layout['width'][$name] : false;
        }
        //default params
        $return->maxcols = (int)$params->maxcols;

        $return->params = array();

        //
        foreach ($this->getlayout->static['avaiableoptions'] as $key => $value) {
            if (in_array($value, $params->poslayout['params'])) {
                // $return->tab_menus[] = "options";
                $return->params = array_merge($return->params, $this->getlayout->params[$value]);
            }
        }

        //$true_false = array("numeric_position", "canchange", 'colchange', "invisible");
        foreach ($this->getlayout->static['truefalse'] as $key => $value) {
            if (!isset($return->$value))
                $return->$value = false;
        }

        $subpositions = array("positions", "innertop", "innerbottom");
        foreach ($subpositions as $key => $value) {
            $return->$value = $return->poslayout[$value];
        }
        $return->devices = $this->getlayout->static['devices'];


        return $return;
    }

    function get_layout_params($return)
    {
        foreach ($return->poslayout['params'] as $key => $value) {
            foreach ($this->getlayout->params[$value] as $gp => $param) {
                $return->$gp = $param;
            }
        }
        return $return;
    }

    function get_positions_details($posdata, $pos)
    {
        $return = new \stdClass();

        if ($posdata->positions == false) {
            $get_det = $this->elabora_posdata($pos);
            $get_positions = $pos;
            $get_cols = $get_det->maxcols;
        } else {
            $get_positions = implode(",", $posdata->positions);
            $cols = array();
            foreach ($posdata->positions as $key => $value) {
                $get_posas = $this->elabora_posdata($value);
                $cols[] = $get_posas->maxcols;
            }
            $get_cols = implode(",", $cols);
        }
        $return->maxcols = $get_cols;
        $return->positions = $get_positions;
        return $return;
    }
    function child_nopadding($position)
    {
        $return = '';
        foreach(['pc',"tablet","mobile"] as $key=>$value){
            if (isset($this->layout['css'][$value][$position.'_subsection']['child_disable_padding']) &&
                $this->layout['css'][$value][$position.'_subsection']['child_disable_padding'] == "disable") {
               switch ($value){
                   case "pc": $return .=' pc-child-nopadding';break;
                   case "tablet": $return .=' tablet-child-nopadding';break;
                   case "mobile": $return .=' mobile-child-nopadding';break;
               }
            }
        }
        return $return;
    }

    function assign_suspend($position)
    {
        $return = new \stdClass();
        $return->checked = '';
        $return->suspended_class = '';
        if (isset($this->layout['suspended'][$position])) {
            $return->checked = 'checked';
            $return->suspended_class = 'pos_suspended';
        }
        return $return;
    }


    function inners_positions($posdata, $loadinner)
    {
        $return = '';
        if ($posdata->$loadinner != false) {


            foreach ($posdata->$loadinner as $key => $inner) {
                //implemento per le opzioni di sezioni
                $section_key = $inner . '_subsection'; //_subsection e' fissaione defiitita in template/admin/layout.php
                $get_subsection = $this->elabora_posdata($section_key);

                $getinner = $this->elabora_posdata($inner);
                $positions_details = $this->get_positions_details($getinner, $inner);
                $suspended = $this->assign_suspend($inner);
                $inner = trim($inner);
                $return .= ' <div id="pos_' . $inner . '" class="' . $suspended->suspended_class . ' position ' . $getinner->width . '">';
                $return .= '  <div style="text-align: center;"> <strong> ' . Text::_("COM_TMARLEV_BLOCK_OF_POSITION") . ' ' . $inner . '</strong></div>';
                $return .= '  <div class="add-position-block"> <div class="d-flex justify-content-center"><span class="add-position" data-id="pos_' . $inner . '" data-class="innerposition" data-maxcols="' . $positions_details->maxcols . '"  data-positions="' . $positions_details->positions . '"><span   class="hasTooltip icon-plus" title="' . Text::_('COM_TMARLEV_ADD_POSITION_LABEL') . '"></span></span>'
                    . '<span class="suspend-position-block hasTooltip " data-original-title="' . Text::_('COM_TMARLEV_SUSPEND_UNSUSPEND_POSITION') . '">'
                    . '<span class="form-check form-switch"><input id="checkbox-' . $inner . '" ' . $suspended->checked . ' class="suspend-position form-check-input" role="switch" data-id="pos_' . $inner . '" type="checkbox" value="1" name="layout[suspended][' . $inner . ']">
                            <label class="form-check-label" for="checkbox-' . $inner . '"></label></span></span>'
                    . $this->in_popup($section_key, $section_key, '', $get_subsection, ucfirst($inner)) . '</div></div>'
                    . '<div class="row">'
                    . '<input type="hidden" id="pos_' . $inner . '-positions" value="' . implode(",", $getinner->defpositions) . '" name="layout[positions][' . $inner . ']">'
                    . '  <input type="hidden" id="pos_' . $inner . '-input" value="' . str_replace("row-fluid","child-row-padding-0",$getinner->width) . '" name="layout[width][' . $inner . ']">'
                    . '  <input type="hidden" id="pos_' . $inner . '-mobcollayout" value="' . implode(",", $getinner->mobcollayout) . '" name="layout[mobcollayout][' . $inner . ']">'
                    . '  <input type="hidden" id="pos_' . $inner . '-tabcollayout" value="' . implode(",", $getinner->tabcollayout) . '" name="layout[tabcollayout][' . $inner . ']">'
                    . '  <input type="hidden" id="pos_' . $inner . '-defcollayout" value="' . implode(",", $getinner->defcollayout) . '" name="layout[defcollayout][' . $inner . ']">'
                    .  ' <input type="hidden"  value="'.$section_key.'" name="layout[sections][]">' ;

                $return .= $this->show_subbpositions($getinner, $inner, 'innerposition', $getinner->defpositions);

                $return .= '<div class="w-100 end-position"></div></div>';
                $return .= "</div>";
            }
        }
        return $return;
    }

    static function get_modules($array)
    {
        $return = array();
        $positions = "'" . preg_replace("|^,|", "", implode("','", $array)) . "'";
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('title,position,id');
        $query->from('#__modules');
        $query->where('client_id=0');
        $query->where('published=1');
        $query->where("position IN (" . $positions . ")");
        $db->setQuery($query);
        $pos = $db->loadObjectList();

        foreach ($pos as $key) {
            if (key_exists($key->position, $return)) {
                //  $return[$key->position] = new \stdClass();
                $return[$key->position]->id = false;
                $return[$key->position]->title = $return[$key->position]->title . "<br/>" . $key->title;
            } else {
                $return[$key->position] = new \stdClass();
                $return[$key->position]->id = $key->id;
                $return[$key->position]->title = $key->title;
            }
        }
        return $return;
    }

    static function show_modules($posname, $modules)
    {
        if (key_exists($posname, $modules)) {
            if ($modules[$posname]->id == false) {
                return ' &nbsp;&nbsp;<span><a class="edit-modules hasTooltip" title="' . Text::_("COM_TMARLEV_MODULES") . '<br/> ' . $modules[$posname]->title . '" href="index.php?option=com_modules&view=modules&client_id=0&filter[position]=' . $posname . '" target="_blank"></span></a>';
            } else {
                return ' &nbsp;&nbsp;<span><a class="edit-modules hasTooltip" title="' . Text::_("COM_TMARLEV_MODULE") . '<br/> ' . $modules[$posname]->title . '"  href="index.php?option=com_modules&task=module.edit&id=' . $modules[$posname]->id . '" target="_blank"></span></a>';
            }
        }
        return "";
    }

    function show_subbpositions($posdata, $pos, $positionclass, $defpositions)
    {
        $return = '';
        $parentid = 'pos_' . $pos;
        $i = 1;
        $modules = self::get_modules($defpositions);
        foreach ($defpositions as $key => $value) {
            if (!empty($value)) {
                $posname = $value;
                $selected = new \stdClass;

                $selected->tablet = $posdata->tabcollayout[$i - 1];
                $selected->mobile = $posdata->mobcollayout[$i - 1];
                $selected->pc = $posdata->defcollayout[$i - 1];
                $push_pull_offset = "";
                if ($this->layout != false) {
                    foreach ($posdata->devices as $key => $value) {
                        if(isset($this->layout['order' . $value][$posname])){
                            $push_pull_offset .= " " . $this->layout['order' . $value][$posname];
                        }
                        else {
                            $push_pull_offset .= " ";
                        }
                        if(isset($this->layout['offset' . $value][$posname])) {
                            $push_pull_offset .= " " . $this->layout['offset' . $value][$posname];
                        }
                        //$push_pull_offset .= " " . $this->layout['push' . $value][$posname];
                        //$push_pull_offset .= " " . $this->layout['pull' . $value][$posname];
                    }
                }

                $return .= '<div class="pos_' . $posname . ' ' . $positionclass . ' col-md-' . $selected->pc . ' col-lg-' . $selected->pc . ' col-' . $selected->mobile . ' col-sm-' . $selected->tablet . ' ' . $push_pull_offset . '" data-mobile="' . $selected->mobile . '" data-tablet="' . $selected->tablet . '" data-pc="' . $selected->pc . '" data-position="' . $posname . '"> ';
                $return .= '<div style="padding: 2px"> <div class="show-position">';

                $return .= '<div>' . $posname . '</div>';
                $return .= $this->in_popup($parentid, $posname, $selected, $posdata, $posname);
                $return .= self::show_modules($posname, $modules);
                $return .= '&nbsp;&nbsp;<span class="colcancel"><span class="hasTooltip icon-cancel" title="' . Text::_('COM_TMARLEV_DELETE_THIS_COL') . '"></span></span>';
                $return .= '</div></div></div>';
                $return .= $this->if_clear_after_pos_enabled($posname);

                $i++;
            }
        }
        return $return;
    }

    protected function if_clear_after_pos_enabled($posname)
    {
        $return = "";
        $devices = ["pc" => "gy-2 d-none d-md-block clear-pc", "tablet" => "gy-2 d-none d-sm-block d-md-none clear-tablet", "mobile" => "gy-2 d-block d-sm-none clear-mobile"];
        foreach ($devices as $key => $value) {
            if (isset($this->layout['addclear' . $key][$posname]) && $this->layout['addclear' . $key][$posname] == '1') {
                $return .= '<div id="clear-' . $key . '-' . $posname . '" class="w-100 ' . $value . '"></div>';
            }
        }

        return $return;
    }

    function col_denied_change($posname, $posdata)
    {
        $return = '';
        //$array = array("hide", "push", "offset", "pull");
        $array = array("hide", "order", "offset");

        foreach ($posdata->devices as $key => $value) {
            $return .= '<input type="hidden" name="layout[' . $value . '][' . $posname . ']" value="12" >';
            foreach ($array as $k => $v) {
                $return .= '<input type="hidden" name="layout[' . $v . $value . '][' . $posname . ']" value="ml-' . $value . '-show" >';
            }
        }

        return $return;
    }

    function in_popup($parentid, $posname, $selected, $posdata, $nomevisualizzato)
    {
        $this->editconfigid["#editconfig-" . $posname] = $posname;
        $export_type = "position";
        if(preg_match("&(_subsection|_section|ml_body)&",$posname)){
            $export_type="section";
        }
        $return = '<span class="options-block" id="posconfig-' . $posname . '" data-export-type="'.$export_type.'" data-parentid="' . $parentid . '"  data-subpos="' . $posname . '" data-funcs="nofuncs"';
        $return .=" data-selected='" . json_encode($selected) . "'";
        $return .= " data-subposdata='" . json_encode($posdata) . "'";
        $return .= ' data-nomevisualizzato="' . $nomevisualizzato . '"><span class="edit-block-options"><a id="openoptions-' . $posname . '" class="edit-options" data-funcs="nofuncs" title="' . Text::_("COM_TMARLEV_EDIT") . '" data-parentid="#edit-' . $posname . '"  data-configid="#configid-' . $posname . '"  ><span class="icon-apply"></span></a></span></span>';
        return $return;
      //  return "<span class='posconfig' id='posconfig-" . $posname . "' data-parentid='" . $parentid . "'  data-subpos='" . $posname . "'  data-selected='" . json_encode($selected) . "'  data-subposdata='" . json_encode($posdata) . "'  data-nomevisualizzato='" . $nomevisualizzato . "' ><a><span class='icon-apply'></span></a></span>";
    }

    function posconfig($parentid, $posname, $selected, $posdata, $nomevisualizzato)
    {
        $return = '';
        if ($posdata->options) {
           // $return .= '<span class="options-block"><span class="edit-block-options"><a id="openoptions-' . $posname . '" class="edit-options" title="' . Text::_("COM_TMARLEV_EDIT") . '" data-parentid="#edit-' . $posname . '"  data-configid="#configid-' . $posname . '" ><span class="icon-apply"></span></a></span></span>';
            $return .= '<div id="edit-' . $posname . '" class="config-block" data-posconfig="#posconfig-'.$posname.'">';
            $return .= '<div id="configid-' . $posname . '" class="ml-configs" data-parent="#edit-' . $posname . '">';
            $return .= '<div class="slider-posname" >' . Text::_("COM_TNARLEV_OPTIONS_OF") . ' ' . str_replace(["_section","_subsection"],"",$nomevisualizzato) . '</div><div class="close-slider" data-parent="null"><img src="' . Uri::base() . 'components/com_tmarlevv2/images/close.png" ></div>';
            $return .= "<div class='clearfix'></div>";

            $return .= '<div class="actions-views-block"><div class="copy-actions">';
            $return .= '<a href="#" data-type="export" class="action-devices btn btn-small btn-danger">Export</a>';
            $return .= '<a href="#" data-type="actions" class="action-positions btn btn-small btn-success">' . Text::_("COM_TMARLEV_TRANSFER_CONFIG") . '</a>';
            $return .= '<a href="#" data-type="copy" class="action-devices btn btn-small btn-primary">' . Text::_("COM_TMARLEV_COPY_DEVICE") . '</a>';
            $return .= '</div>';


            $return .= '<div class="select-edit-device" >';

            foreach ($posdata->devices as $dv => $devicechoise) {
                $this_checked = "";
                $class_checked = 'class="change-config-view"';
                if ($devicechoise == "pc") {
                    $this_checked = "checked";
                    $class_checked = 'class="checbox-checked change-config-view"';
                    $data_view = "view-desktop";
                } else if ($devicechoise == "tablet") {
                    $data_view = "view-tablet";
                } else if ($devicechoise == "mobile") {
                    $data_view = "view-mobile";
                }

                $return .= '<div class="checkbox checkbox-primary checkbox-intabtop form-check-inline">'
                    . '<input ' . $class_checked . ' ' . $this_checked . ' type="checkbox" data-view="' . $data_view . '" data-configid="editconfig-' . $posname . '-' . $devicechoise . '"  id="checkbox-' . $posname . '-' . $devicechoise . '" value="1" >';
                $return .= '<label for="checkbox-' . $posname . '-' . $devicechoise . '"> ' . ucfirst($devicechoise) . '</label></div>';
            }
            $return .= "</div><div class='clearfix'></div></div>";



            $return .= '<div class="copy-actions-block" data-state="close">';

            //for transfer
            $return .= '<div class="for-export" style="height:auto">';
            $return .= '<div style="margin-bottom:5px;">' . Text::_("COM_TMARLEV_EXPORT_POSITION_CONFIG") . '</div>';

//            $return .= '<div class=" checkbox checkbox-primary checkbox-intab checkbox-inline">'
//                . '<input  type="checkbox" class="copy-params-device"   value="1" >';
//            $return .= '<label data-eseguito="' . Text::_("COM_TMARLEV_COPY_DEVICE_CONFIG_FOR_ALL_DEVICE_DONE") . '" data-default="' . Text::_("COM_TMARLEV_COPY_DEVICE") . '" >' . Text::_("COM_TMARLEV_COPY_DEVICE") . '</label>';
//            $return .= "</div>";
            $return .= "<div class='export-posto'></div>";
            $return .= "<div class='export-posto-btn'><a data-eseguito='" . Text::_("COM_TMARLEV_COPY_DEVICE_CONFIG_FOR_ALL_DEVICE_DONE") . "' data-selecttemplatefirst='" . Text::_("COM_TMARLEV_FOR_COPY_SELECT_TEMPLATE_FIRST") . "'  data-copyconfig='editconfig-" . $posname . "' href='#' class='export-config-now btn btn-small btn-success' data-text='".Text::_('COM_TMARLEV_EXPORT')."'>" . Text::_('COM_TMARLEV_EXPORT') . "</a></div>";

            //$return .= '<div style=";font-size:12px;">' . Text::_("COM_TMARLEV_COPY_DEVICE_CONFIG_FOR_ALL_DEVICE_ADVISE") . '</div>';
            $return .= "</div>";
            $return .= "<div class='clearfix'></div>";
            //end transfer

            $return .= '<div class="for-all-device" style="height:auto">';
            $return .= '<div style="margin-bottom:5px;">' . Text::_("COM_TMARLEV_COPY_DEVICE_CONFIG_FOR_ALL_DEVICE") . '</div>';

            $return .= '<div class=" checkbox checkbox-primary checkbox-intab checkbox-inline">'
                . '<input  type="checkbox" class="copy-params-device"   value="1" >';
            $return .= '<label data-eseguito="' . Text::_("COM_TMARLEV_COPY_DEVICE_CONFIG_FOR_ALL_DEVICE_DONE") . '" data-default="' . Text::_("COM_TMARLEV_COPY_DEVICE") . '" >' . Text::_("COM_TMARLEV_COPY_DEVICE") . '</label>';
            $return .= "</div>";

            $return .= '<div style="font-size:12px;">' . Text::_("COM_TMARLEV_COPY_DEVICE_CONFIG_FOR_ALL_DEVICE_ADVISE") . '</div>';
            $return .= "</div>";


            $return .= '<div class="for-positions" style="height:auto;">';
            $return .= '<div style="margin-bottom:10px;">' . Text::_("COM_TMARLEV_COPY_POSITINS_CONFIG_DESK") . '</div>';

            //select device to copy
            $return .= '<div class="select-device-tocopy">';
            $return .= '<div class="checkbox checkbox-primary checkbox-intab checkbox-inline">'
                . '<input  type="checkbox" checked data-copy="all" class="copy-all transfer-config"  id="copy-' . $posname . '-all" value="1" >';
            $return .= '<label for="copy-' . $posname . '-all">' . Text::_("COM_TMARLEV_ALL") . '</label></div>';
            foreach ($posdata->devices as $dv => $devicechoise) {

                $return .= '<div class="checkbox checkbox-primary checkbox-intab checkbox-inline">'
                    . '<input  type="checkbox" data-copy="' . $devicechoise . '" class="transfer-config copy-' . $devicechoise . '" id="copy-' . $posname . '-' . $devicechoise . '" value="1" >';
                $return .= '<label for="copy-' . $posname . '-' . $devicechoise . '">' . ucfirst($devicechoise) . '</label></div>';
            }
            //end
            $return .= "</div>";
            $return .= "<div class='positions-posto'></div>";
            $return .= "<div class='copy-config-now-block'><a data-eseguito='" . Text::_("COM_TMARLEV_COPY_DEVICE_CONFIG_FOR_ALL_DEVICE_DONE") . "' data-selectdestination='" . Text::_("COM_TMARLEV_FOR_COPY_SELECT_POSITINS_FIRST") . "' data-selectdevicefrst='" . Text::_("COM_TMARLEV_FOR_COPY_SELECT_DEVICE_FIRST") . "' data-copyconfig='editconfig-" . $posname . "' href='#' class='copy-config-now btn btn-small btn-success'>" . Text::_('COM_TMARLEV_COPY_DEVICE') . "</a></div>";
            $return .= '<div class="clearfix"></div><div style="font-size:12px;">' . Text::_("COM_TMARLEV_COPY_DEVICE_CONFIG_FOR_ALL_POSITION_ADVISE") . '</div>';
            $return .= "</div>";
            $return .= "</div>";
            $ml_tab_options = new ml_tab_options($posname, $this->layout, $this->template_name);
            $devices_options = new ml_device_options($posdata, $posname, $parentid, $selected, $this->layout, $this->template_name);


            $return .= '<div class="edit-options-bx">';
            foreach ($posdata->devices as $v => $value) {
                $define_active = 1;

                $hide_block = ($value == "pc") ? "" : 'style="display:none"';
                $active = ($define_active == 1) ? "active" : "";

                $return .= '<div ' . $hide_block . ' id="editconfig-' . $posname . '-' . $value . '">';
                $return .= HtmlHelper::_('bootstrap.startTabSet', 'myTab' . $posname . $value, array('active' => $posname . $value . "-" . 1));

                if ($posdata->colchange) {
                    $return .= HtmlHelper::_('bootstrap.addTab', 'myTab' . $posname . $value, $posname . $value . "-" . $define_active, Text::_("Layout"));
                    $return .= '<div class="params-block" data-active="' . $active . '" data-type="' . strtoupper($value) . '">';
                    $return .= $devices_options->devices($value);
                    $return .= '</div>';
                    $return .= HtmlHelper::_('bootstrap.endTab');
                    $define_active++;
                }
                if (isset($posdata->font)) {

                    $return .= HtmlHelper::_('bootstrap.addTab', 'myTab' . $posname . $value, $posname . $value . "-" . $define_active, "Font");
                    $return .= '<div class="params-block" data-active="' . $active . '" data-type="' . strtoupper($value) . '">';
                    $return .= $ml_tab_options->tab_options($posdata, $posname, $value, "font");
                    $return .= '</div>';
                    $return .= HtmlHelper::_('bootstrap.endTab');
                    $define_active++;
                }
                if (isset($posdata->backgroundall)) {

                    $return .= HtmlHelper::_('bootstrap.addTab', 'myTab' . $posname . $value, $posname . $value . "-" . $define_active, Text::_("COM_TMARLEV_TABBACKGROUND_TYPE"));
                    $return .= '<div class="params-block" data-active="' . $active . '" data-type="' . strtoupper($value) . '">';
                    $return .= $ml_tab_options->tab_options($posdata, $posname, $value, "sfondo");
                    $return .= '</div>';
                    $return .= HtmlHelper::_('bootstrap.endTab');
                    $define_active++;
                } elseif (!isset($posdata->backgroundall) && isset($posdata->effect)) {

                    $return .= HtmlHelper::_('bootstrap.addTab', 'myTab' . $posname . $value, $posname . $value . "-" . $define_active, Text::_("COM_TMARLEV_BACKGROUND_EFFECT"));
                    $return .= '<div class="params-block" data-active="' . $active . '" data-type="' . strtoupper($value) . '">';
                    $return .= $ml_tab_options->tab_options($posdata, $posname, $value, "effect");
                    $return .= '</div>';
                    $return .= HtmlHelper::_('bootstrap.endTab');
                    $define_active++;
                }
                if (isset($posdata->shadow)) {

                    $return .= HtmlHelper::_('bootstrap.addTab', 'myTab' . $posname . $value, $posname . $value . "-" . $define_active, Text::_("Shadow"));
                    $return .= '<div class="params-block" data-active="' . $active . '" data-type="' . strtoupper($value) . '">';
                    $return .= $ml_tab_options->tab_options($posdata, $posname, $value, "shadow");
                    $return .= '</div>';
                    $return .= HtmlHelper::_('bootstrap.endTab');
                    $define_active++;
                }
                if (isset($posdata->stile)) {

                    $return .= HtmlHelper::_('bootstrap.addTab', 'myTab' . $posname . $value, $posname . $value . "-" . $define_active, Text::_("COM_TMARLEV_BACKGROUND_STYLE"));
                    $return .= '<div class="params-block" data-active="' . $active . '" data-type="' . strtoupper($value) . '">';
                    $return .= $ml_tab_options->tab_options($posdata, $posname, $value, "stile");
                    $return .= '</div>';
                    $return .= HtmlHelper::_('bootstrap.endTab');
                    $define_active++;
                }
                if (isset($posdata->child)) {

                    $return .= HtmlHelper::_('bootstrap.addTab', 'myTab' . $posname . $value, $posname . $value . "-" . $define_active, Text::_("COM_TMARLEV_CHILD"));
                    $return .= '<div class="params-block" data-active="' . $active . '" data-type="' . strtoupper($value) . '">';
                    $return .= $ml_tab_options->tab_options($posdata, $posname, $value, "child");
                    $return .= '</div>';
                    $return .= HtmlHelper::_('bootstrap.endTab');
                    $define_active++;
                }
//                if (isset($posdata->flex)) {
//
//                    $return .= HtmlHelper::_('bootstrap.addTab', 'myTab' . $posname . $value, $posname . $value . "-" . $define_active, Text::_("Flex"));
//                    $return .= '<div class="params-block" data-active="' . $active . '" data-type="' . strtoupper($value) . '">';
//                    $return .= $ml_tab_options->tab_options($posdata, $posname, $value, "flex");
//                    $return .= '</div>';
//                    $return .= HtmlHelper::_('bootstrap.endTab');
//                    $define_active++;
//                }


                $return .= HtmlHelper::_('bootstrap.endTabSet');
                $return .= '</div>';
            }


            $return .= '</div>';
            $return .= '</div>';
            $return .= ' </div>';
        } else {
            $return .= $this->col_denied_change($posname, $posdata);
        }

        return $return;
    }

    function get_multiselect_positions()
    {
        $options = array();
        foreach ($this->editconfigid as $key => $value) {

            $value = str_replace(["_section", "_subsection"], "", $value);
            $options[] = HtmlHelper::_('select.option', $key, $value);
        }
        return HtmlHelper::_('select.genericlist', $options, '', 'multiple="multiple" data-placeholder="' . Text::_("COM_TMARLEV_SELECT_POSITIONS_OR_BLOCKS") . '" id="avvaiable_positions_multi"', 'value', 'text', "");
    }
    function get_duplicates_template()
    {
        $id = Factory::getApplication()->input->getInt("id",0);
        $options = array();
        if($id > 0) {
            $db = Factory::getDbo();
            $query = $db->getQuery(true);
            $query->select('a.id, a.title,b.tid');
            $query->from('#__template_styles as a');
            $query->join('INNER', $db->quoteName('#__tmarlevv2_layout', 'b') . ' ON ' . $db->quoteName('a.id') . ' = ' . $db->quoteName('b.tid'));
            $query->where('a.template=' . $db->Quote($this->template_name));
            $query->where('a.id !=' . $db->Quote($id));
            $db->setQuery($query);
            $template = $db->loadObjectList();
        }
        $options[] = HtmlHelper::_('select.option', "", Text::_("COM_TMARLEV_SELECT_DUPLICATES"));
            if(isset($template[0])) {
                foreach ($template as $key) {
                    $options[] = HtmlHelper::_('select.option', $key->id, $key->title);
                }
            }
            return HtmlHelper::_('select.genericlist', $options, '', ' data-placeholder="' . Text::_("COM_TMARLEV_SELECT_DUPLICATES") . '" style="width:250px" id="duplicates_template_select"', 'value', 'text', "");

    }
    function get_editable_positions()
    {
        $options = array();
        $options[] = HtmlHelper::_('select.option', "editposition", Text::_("COM_TMARLEV_EDIT_POSITION"));
        foreach ($this->editconfigid as $key => $value) {

            $value = str_replace(["_section", "_subsection"], "", $value);
            $key = str_replace("editconfig", "openoptions", $key);
            $options[] = HtmlHelper::_('select.option', $key, $value);
        }
        return HtmlHelper::_('select.genericlist', $options, '', ' id="editable_positions_1" data-sequenzial="1" class="editable_positions"', 'value', 'text', "editposition");
    }
}
