<?php

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

jimport('joomla.form.formfield');
JFormHelper::loadFieldClass('spacer');

class JFormFieldSystem extends JFormFieldSpacer {

    protected $type = 'System';

    function __construct() {

        $warnHandlers = JERROR::getErrorHandling(E_WARNING);
        JERROR::setErrorHandling(E_WARNING, 'ignore');


        if (!JComponentHelper::isEnabled('com_tmarlevv2', true)) {
            $this->add_script();
            return false;
        } 
            $app = JFactory::getApplication();
            $input = JFactory::getApplication()->input;
            $id = $input->getInt("id");
            $tid = $this->check_layout($id);
            if ($tid > 0) {
                $app->redirect("index.php?option=com_tmarlevv2&view=template&id=" . $id);
                return true;
            }
            
                $this->copy_matlev_template($id);
               // if ($response == true) {
               //     $app->redirect("index.php?option=com_tmarlevv2&view=template&id=" . $id);
              //  } else {
                    $session = JFactory::getSession();
                    $create_message = [];
                    $create_message["clone-template"][] = "messaggio in model";
                    $tojson = json_encode($create_message);
                    $session->set('marlev_install_message', $tojson);
                    
                    $app->redirect("index.php?option=com_tmarlevv2&view=template&id=" . $id . "&installtype=install");
             //   }
           
        
    }

    protected function copy_matlev_template($id) {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('a.params');
        $query->from('#__template_styles AS a');
        $query->where('a.id=' . $db->Quote($id));
        $db->setQuery($query);
        $template = $db->loadResult();
        $return = false;
        if (!empty($template)) {
            $registry = new JRegistry;
            $registry->loadString($template);
            $tparams = $registry->toArray();
            $layoutid = $tparams['layoutid'];
            $return = $this->clone_layout($layoutid, $id);
        }
        return $return;
    }

    protected function clone_layout($layoutid, $id) {
        $return = true;
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('layout');
        $query->from('#__tmarlevv2_layout');
        $query->where('id=' . $db->Quote($layoutid));
        $db->setQuery($query);
        $template = $db->loadResult();
        if (!empty($template)) {
            $update = new stdClass();
            $update->layout = $template;
            $update->tid = $id;
            $result = JFactory::getDbo()->insertObject('#__tmarlevv2_layout', $update);
            if ($result) {
                $return = false;
            }
        }
        return $return;
    }

    protected function check_layout($id) {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('id');
        $query->from('#__tmarlevv2_layout');
        $query->where('tid=' . $db->Quote($id));
        $db->setQuery($query);
        $tid = $db->loadResult();
        return $tid;
    }

    protected function add_script() {
        $document = JFactory::getDocument();
        $messagge = "<div style='text-align:center; margin-top:40px'><h2>" . JText::_('Error detected, reinstall Template') . "</h2></div>";
        $show = 'jQuery(document).ready(function() {
            jQuery("#toolbar-apply, #toolbar-save, #save-copy, #toolbar-save-copy").remove();
                        jQuery("#system-message-container, #myTabTabs, #myTabContent, .control-group ").remove()
                        jQuery(".container-main").find(".span12").prepend("' . $messagge . '"); 
                    });';
        $document->addScriptDeclaration($show);
    }

}

?>