
<?php
use Joomla\CMS\HTML\HTMLHelper;
//for_use

/**
 * @extension       Marlev Templates
 * @author          Lev Milicenco <support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2015 marlev.it All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 *
 */
defined('_JEXEC') or die;
if (!defined('DS'))
    define('DS', DIRECTORY_SEPARATOR);

use Joomla\CMS\Factory;
use Joomla\CMS\Version;

$input = Factory::getApplication()->input;
$loadoffline = $input->getInt("loadoffline", false);

$params = Factory::getApplication()->getTemplate(true)->params;
$xml = simplexml_load_file(JPATH_SITE . DS . 'templates' . DS . Factory::getApplication()->getTemplate(true)->template . DS . 'templateDetails.xml');
$rand_query = (string)$xml->version;
HtmlHelper::_('jquery.framework');
$app = Factory::getApplication();
$app->getDocument()->getWebAssetManager()
    ->disableStyle('fontawesome')
    ->addInlineStyle(":root {
		--template-font-awe: 'Font Awesome ".((Version::MAJOR_VERSION == 5)?6:5)." Free';
	}")
    ->registerAndUseStyle('tpl_' . $this->template . "_bootstrap", 'templates/' . $this->template . '/css/bootstrap.css')
    ->registerAndUseStyle('tpl_' . $this->template . "_template", 'templates/' . $this->template . '/css/template.css')
    ->registerAndUseStyle('tpl_' . $this->template . "_layout-" . $params->get('tid'), 'templates/' . $this->template . '/css/layouts/' . $this->template . '-' . $params->get('tid') . '.css', ['version' => $params->get("custom_version","v1")])
    ->registerAndUseStyle('tpl_' . $this->template . "_slides", 'templates/' . $this->template . '/css/slides.css')
    ->registerAndUseStyle('tpl_' . $this->template . "_custom", 'templates/' . $this->template . '/custom/css.css', ['version' => $params->get("custom_version","v1")])
    ->registerAndUseStyle('tpl_' . $this->template . "_joomla_awesome", 'media/system/css/joomla-fontawesome.min.css')
    ->registerAndUseScript('tpl_' . $this->template . "_js", 'templates/' . $this->template . '/js/js.js')
    ->registerAndUseScript('tpl_' . $this->template . "_customjs", 'templates/' . $this->template . '/custom/js.js', ['version' => $params->get("custom_version","v1")]);

if ($params->get('bootstrapselect') == true) {
    HtmlHelper::_('formbehavior.chosen', $params->get('bootstrapselect_classes', ".form-select"));
}
if ($params->get('logo') == true) {
    $logo = htmlspecialchars($this->baseurl . '/' . $params->get('logo'));
} else {
    $logo = htmlspecialchars($this->baseurl . '/templates/' . $this->template . '/images/default-logo.png');
}


require_once JPATH_BASE . '/templates/' . $this->template . '/lib/layout.php';
require_once JPATH_BASE . '/templates/' . $this->template . '/lib/helper.php';
require_once JPATH_BASE . '/templates/' . $this->template . '/lib/template.php';
$getlayout = defined_layout();
$tlayout = $params->get('tlayout', false);
$error = false;
if (isset($this->error)) {
    $error = true;
}
$content = new ml_template_render($getlayout, $tlayout, $logo, $params, $this->baseurl, $this->template, $error);
$template = $this->baseurl . '/templates/' . $this->template . '/';
//Cookie alert

$cookiealert_on = $params->get('cookie_enable', 0);
$cookie_position = $params->get('cookie_position', "bottom");
$cookie_post = $input->getString('accettocookie');
if ($cookie_post == "cookie-consentiti") {
    $domain = ($_SERVER['HTTP_HOST'] != 'localhost') ? $_SERVER['HTTP_HOST'] : false;
    setcookie('cookie-consentiti-' . $this->template, "accept", time() + (10 * 365 * 24 * 60 * 60), '/', $domain, false);
}


$Changefavicon = $params->get('changeFavicon');
?>
    <meta name=viewport content="width=device-width, initial-scale=1">
    <link rel="shortcut icon"
          href="<?php echo $this->baseurl ?>/<?php echo (!empty($Changefavicon)) ? $Changefavicon : 'templates/' . $this->template . '/favicon.png'; ?>"/>
<?php if ($params->get('pcmenulayout', 'slide') === "slide") { ?>
    <script type="text/javascript">
        <?php
        if ($params->get("slidelogo", false) !== false) {
            $logo = htmlspecialchars($this->baseurl . '/' . $params->get("slidelogo"));
        }
        ?>
        jQuery(document).ready(function () {
            var ml_slidelogo_params = {
                "show_logo_slide": '<?php echo $params->get("show_logo_slide", "hide"); ?>',
                "slidelogoheight": '<?php echo $params->get("slidelogowidth", 3); ?>',
                "logoslideralign": '<?php echo $params->get("logoslideralign", "center"); ?>',
                "slidelogoeffect": '<?php echo $params->get("slidelogoeffect", "null"); ?>',
                "slidelogowidthimg": '<?php echo $params->get("slidelogowidthimg", 216); ?>',
                "slidelogomargintop": '<?php echo $params->get("slidelogomargintop", 7); ?>',
                "slidelogomarginleft": '<?php echo $params->get("slidelogomarginleft", 0); ?>',
                "slidelogoheightimg": '<?php echo $params->get("slidelogoheightimg", 45); ?>',

                "slidelogo": '<?php echo $logo; ?>'
            };

            jQuery.marlevSlideMenu(ml_slidelogo_params);
            jQuery(window).scroll(function () {
                jQuery.marlevSlideMenu(ml_slidelogo_params);
            });
        });
    </script>
    <?php
}
//if ($params->get('btnstyle', false) !== false) {
?>
    <script type="text/javascript">
        jQuery(document).ready(function () {
            jQuery.rewrite_btn_style("<?php echo $params->get('btnstyle', "btn-secondary"); ?>");
            jQuery.article_info("<?php echo $params->get('btnstyle', "btn-secondary"); ?>");
            jQuery(window).resize(function () {
                jQuery.article_info("<?php echo $params->get('btnstyle', "btn-secondary"); ?>");
            });
        });
    </script>
<?php
//}
