<?php
namespace Marlev\Component\Tmarlevv2\Administrator\Helper;
/**
 * @extension       Template Manager
 * @author          Lev Milicenco <support@marlev.it>
 * @link            http://www.marlev.it
 * @copyright       Copyright 2017 marlev.it All Rights Reserved

 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

use Joomla\CMS\Uri\Uri;
use Joomla\Registry\Registry;
//for_use
defined('_JEXEC') or die;

class cachedcssjs_files
{

    public static function css_js_esclude($params)
    {
        $css_js_esclude_toshow = array("media/system/css/joomla-fontawesome.min.css");
        $tparams = self::prepare_params($params);
        $return = new \stdClass();
        $css = null;
        $js = null;
        if (isset($tparams['name'])) {
            $cashfolder = JPATH_ROOT . '/cache/' . $tparams['name'] . "_template";
            if (is_dir($cashfolder)) {
                $files = self::get_files($cashfolder);
                $css = self::prepare_array($files->css);
                $js = self::prepare_array($files->js);
                foreach ($css_js_esclude_toshow as $gkey => $esclude) {
                    if (($search_css = array_search($esclude, $css)) !== false) {
                        unset($css[$search_css]);
                    }
                    if (($search_js = array_search($esclude, $js)) !== false) {
                        unset($js[$search_js]);
                    }
                }

            }
        }


        $make_select_css = self::make_select($css, $tparams, 'yrminifiercss_esclude');
        $make_select_js = self::make_select($js, $tparams, 'yrminifierjs_esclude');
        $return->css = $make_select_css;
        $return->js = $make_select_js;
        return $return;
    }

    protected static function make_select($cached = null, $tparams = null, $option = null)
    {

        $return = ' <select id="params_' . $option . '"  multiple="" name="params[' . $option . '][]" >';
        if (isset($cached[0])) {
            foreach ($cached as $key => $value) {
                $selected = (isset($tparams[$option][0]) && in_array($value, $tparams[$option])) ? "selected" : "";
                $return .= '<option ' . $selected . ' value="' . $value . '">' . $value . '</option>';
            }
        } elseif (isset($tparams[$option])) {

            foreach ($tparams[$option] as $key => $value) {
                $return .= '<option  selected  value="' . $value . '">' . $value . '</option>';
            }
        }

        $return .= '</select>';

        return $return;
    }

    protected static function get_files($cashfolder)
    {
        $scan = scandir($cashfolder);
        $css = array();
        $js = array();
        foreach ($scan as $get => $file) {
            preg_match('/([a-z0-9-]*)(?=\.php)/i', $file, $match);
            if (isset($match[0])) {
                $get_content = file_get_contents($cashfolder . "/" . $file);
                preg_match_all('#(?<=href=\\\\["|\'])([^>]*\.css)#', $get_content, $matchcss);
                if (isset($matchcss[0]))
                    $css[] = $matchcss[0];
                preg_match_all('#(?<=src=\\\\["|\'])([^>]*\.js)#', $get_content, $matchjs);
                if (isset($matchcss[0]))
                    $js[] = $matchjs[0];
            }
        }
        $return = new \stdClass();
        $return->css = $css;
        $return->js = $js;
        return $return;
    }

    static function prepare_params($tparams)
    {
        $registry = new Registry;
        $registry->loadString($tparams);
        $params = $registry->toArray();
        return $params;
    }

    protected static function prepare_array($files)
    {
        $preparefiles = array();
        $merge = array();
        foreach ($files as $g => $cssfile) {
            $preparefiles = str_replace("\/", "/", $cssfile);
            $merge = array_merge($merge, $preparefiles);
        }
        $css = array_unique($merge);
        $make_item = array();
        foreach ($css as $items => $item) {
            $make_item[] = preg_replace('#((https?:+/+|' . Uri::root(true) . ').*(?=components|modules|templates|plugins|media))#', '', $item);
        }
        return $make_item;
    }

}


?>
